/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transport;

import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.giop.TransportListener;
import org.jacorb.transport.Current;
import org.jacorb.transport.DefaultStatisticsProvider;
import org.jacorb.transport.NoContext;
import org.omg.CORBA.LocalObject;
import org.slf4j.Logger;

public class DefaultCurrentImpl
extends LocalObject
implements Current,
TransportListener,
Configurable {
    private int statistics_provider_index_ = -1;
    private static final ThreadLocal tss_transport_event_ = new ThreadLocal();
    private Logger logger_;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration configuration2 = configuration;
        this.logger_ = configuration2.getLogger("jacorb.transport.current");
        List list = configuration2.getAttributeList("jacorb.connection.statistics_providers");
        list.add(DefaultStatisticsProvider.class.getName());
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        configuration2.setAttribute("jacorb.connection.statistics_providers", stringBuffer.toString());
        this.statistics_provider_index_ = list.size() - 1;
    }

    public void transportSelected(TransportListener.Event event) {
        tss_transport_event_.set(event);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Transport selected " + event);
        }
    }

    protected TransportListener.Event getLatestTransportCurentEvent() throws NoContext {
        TransportListener.Event event = (TransportListener.Event)tss_transport_event_.get();
        if (event == null) {
            if (this.logger_.isErrorEnabled()) {
                this.logger_.error("No events were available. Is traits() called outside of an upcall or interceptor?");
            }
            throw new NoContext();
        }
        return event;
    }

    public int id() throws NoContext {
        TransportListener.Event event = this.getLatestTransportCurentEvent();
        return event.hashCode();
    }

    public long bytes_sent() throws NoContext {
        TransportListener.Event event = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider defaultStatisticsProvider = (DefaultStatisticsProvider)event.getStatisticsProvider(this.statistics_provider_index_);
        return defaultStatisticsProvider.bytes_sent_;
    }

    public long bytes_received() throws NoContext {
        TransportListener.Event event = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider defaultStatisticsProvider = (DefaultStatisticsProvider)event.getStatisticsProvider(this.statistics_provider_index_);
        return defaultStatisticsProvider.bytes_received_;
    }

    public long messages_sent() throws NoContext {
        TransportListener.Event event = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider defaultStatisticsProvider = (DefaultStatisticsProvider)event.getStatisticsProvider(this.statistics_provider_index_);
        return defaultStatisticsProvider.messages_sent_;
    }

    public long messages_received() throws NoContext {
        TransportListener.Event event = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider defaultStatisticsProvider = (DefaultStatisticsProvider)event.getStatisticsProvider(this.statistics_provider_index_);
        return defaultStatisticsProvider.messages_received_;
    }

    public long open_since() throws NoContext {
        TransportListener.Event event = this.getLatestTransportCurentEvent();
        DefaultStatisticsProvider defaultStatisticsProvider = (DefaultStatisticsProvider)event.getStatisticsProvider(this.statistics_provider_index_);
        return defaultStatisticsProvider.created_;
    }
}

