/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ws.policy.AssertionBuilderLoader;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderLoader;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertionBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.builders.AlgorithmSuiteBuilder;
import org.apache.cxf.ws.security.policy.builders.AsymmetricBindingBuilder;
import org.apache.cxf.ws.security.policy.builders.ContentEncryptedElementsBuilder;
import org.apache.cxf.ws.security.policy.builders.EncryptedElementsBuilder;
import org.apache.cxf.ws.security.policy.builders.EncryptedPartsBuilder;
import org.apache.cxf.ws.security.policy.builders.HttpsTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.InitiatorTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.IssuedTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.KeyValueTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.LayoutBuilder;
import org.apache.cxf.ws.security.policy.builders.ProtectionTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.RecipientTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.RequiredElementsBuilder;
import org.apache.cxf.ws.security.policy.builders.RequiredPartsBuilder;
import org.apache.cxf.ws.security.policy.builders.SamlTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.SecureConversationTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.SecurityContextTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.SignedElementsBuilder;
import org.apache.cxf.ws.security.policy.builders.SignedPartsBuilder;
import org.apache.cxf.ws.security.policy.builders.SupportingTokens12Builder;
import org.apache.cxf.ws.security.policy.builders.SupportingTokensBuilder;
import org.apache.cxf.ws.security.policy.builders.SymmetricBindingBuilder;
import org.apache.cxf.ws.security.policy.builders.TransportBindingBuilder;
import org.apache.cxf.ws.security.policy.builders.TransportTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.Trust10Builder;
import org.apache.cxf.ws.security.policy.builders.Trust13Builder;
import org.apache.cxf.ws.security.policy.builders.UsernameTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.WSS10Builder;
import org.apache.cxf.ws.security.policy.builders.WSS11Builder;
import org.apache.cxf.ws.security.policy.builders.X509TokenBuilder;
import org.apache.cxf.ws.security.policy.interceptors.HttpsTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.IssuedTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.SecureConversationTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.UsernameTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.WSSecurityInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.WSSecurityPolicyInterceptorProvider;
import org.apache.neethi.builders.AssertionBuilder;

@NoJSR250Annotations
public final class WSSecurityPolicyLoader
implements PolicyInterceptorProviderLoader,
AssertionBuilderLoader {
    Bus bus;

    public WSSecurityPolicyLoader(Bus b) {
        this.bus = b;
        this.registerBuilders();
        try {
            this.registerProviders();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void registerBuilders() {
        AssertionBuilderRegistry reg = (AssertionBuilderRegistry)this.bus.getExtension(AssertionBuilderRegistry.class);
        if (reg == null) {
            return;
        }
        PolicyBuilder pbuild = (PolicyBuilder)this.bus.getExtension(PolicyBuilder.class);
        reg.registerBuilder((AssertionBuilder)new AlgorithmSuiteBuilder());
        reg.registerBuilder((AssertionBuilder)new AsymmetricBindingBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new ContentEncryptedElementsBuilder());
        reg.registerBuilder((AssertionBuilder)new EncryptedElementsBuilder());
        reg.registerBuilder((AssertionBuilder)new EncryptedPartsBuilder());
        reg.registerBuilder((AssertionBuilder)new HttpsTokenBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new InitiatorTokenBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new IssuedTokenBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new LayoutBuilder());
        reg.registerBuilder((AssertionBuilder)new ProtectionTokenBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new RecipientTokenBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new RequiredElementsBuilder());
        reg.registerBuilder((AssertionBuilder)new RequiredPartsBuilder());
        reg.registerBuilder((AssertionBuilder)new SamlTokenBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new SecureConversationTokenBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new SecurityContextTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new SignedElementsBuilder());
        reg.registerBuilder((AssertionBuilder)new SignedPartsBuilder());
        reg.registerBuilder((AssertionBuilder)new SupportingTokens12Builder(pbuild));
        reg.registerBuilder((AssertionBuilder)new SupportingTokensBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new SymmetricBindingBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new TransportBindingBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new TransportTokenBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new Trust10Builder());
        reg.registerBuilder((AssertionBuilder)new Trust13Builder());
        reg.registerBuilder((AssertionBuilder)new UsernameTokenBuilder(pbuild));
        reg.registerBuilder((AssertionBuilder)new KeyValueTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new WSS10Builder());
        reg.registerBuilder((AssertionBuilder)new WSS11Builder());
        reg.registerBuilder((AssertionBuilder)new X509TokenBuilder(pbuild));
        List<QName> others = Arrays.asList(SP12Constants.INCLUDE_TIMESTAMP, SP11Constants.INCLUDE_TIMESTAMP, SP12Constants.ENCRYPT_SIGNATURE, SP11Constants.ENCRYPT_SIGNATURE, SP12Constants.ONLY_SIGN_ENTIRE_HEADERS_AND_BODY, new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "OnlySignEntireHeadersAndBody"), SP12Constants.WSS_X509_V1_TOKEN_10, SP12Constants.WSS_X509_V1_TOKEN_11, SP12Constants.WSS_X509_V3_TOKEN_10, SP12Constants.WSS_X509_V3_TOKEN_11, SP11Constants.WSS_X509_V1_TOKEN_10, SP11Constants.WSS_X509_V1_TOKEN_11, SP11Constants.WSS_X509_V3_TOKEN_10, SP11Constants.WSS_X509_V3_TOKEN_11, SP12Constants.WSS_X509_PKCS7_TOKEN_11, SP12Constants.WSS_X509_PKI_PATH_V1_TOKEN_11, SP11Constants.WSS_X509_PKCS7_TOKEN_11, SP11Constants.WSS_X509_PKI_PATH_V1_TOKEN_11, SP12Constants.REQUIRE_THUMBPRINT_REFERENCE, SP11Constants.REQUIRE_THUMBPRINT_REFERENCE, SP12Constants.REQUIRE_DERIVED_KEYS, SP11Constants.REQUIRE_DERIVED_KEYS, SP12Constants.REQUIRE_INTERNAL_REFERENCE, SP11Constants.REQUIRE_INTERNAL_REFERENCE, SP12Constants.REQUIRE_ISSUER_SERIAL_REFERENCE, SP11Constants.REQUIRE_ISSUER_SERIAL_REFERENCE, new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptBeforeSigning"), new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "EncryptBeforeSigning"));
        reg.registerBuilder((AssertionBuilder)new PrimitiveAssertionBuilder(others));
    }

    public void registerProviders() {
        PolicyInterceptorProviderRegistry reg = (PolicyInterceptorProviderRegistry)this.bus.getExtension(PolicyInterceptorProviderRegistry.class);
        if (reg == null) {
            return;
        }
        reg.register((PolicyInterceptorProvider)new WSSecurityPolicyInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new WSSecurityInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new HttpsTokenInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new IssuedTokenInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new UsernameTokenInterceptorProvider(this.bus));
        reg.register((PolicyInterceptorProvider)new SecureConversationTokenInterceptorProvider());
    }
}

