/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.compendium.ConfigManagerBase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ConfigManager
extends ConfigManagerBase {
    private static final String LABEL = "configMgr";
    private static final String TITLE = "%configMgr.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/config.css"};
    private static final String PID_FILTER = "pidFilter";
    private static final String PID = "pid";
    private static final String factoryPID = "factoryPid";
    private static final String PLACEHOLDER_PID = "[Temporary PID replaced by real PID upon save]";
    private final String TEMPLATE = this.readTemplateFile("/templates/config.html");
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;

    public ConfigManager() {
        super(LABEL, TITLE, CSS);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pid = request.getParameter(PID);
        if (pid == null) {
            String info = request.getPathInfo();
            pid = WebConsoleUtil.urlDecode(info.substring(info.lastIndexOf(47) + 1));
        }
        String pidFilter = request.getParameter(PID_FILTER);
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (pid == null || pid.length() == 0 || ca == null) {
            return;
        }
        PlaceholderConfiguration config = null;
        if (request.getParameter("create") != null) {
            config = new PlaceholderConfiguration(pid);
            pid = config.getPid();
        } else if (request.getParameter("apply") != null) {
            String redirect = this.applyConfiguration(request, ca, pid);
            if (redirect != null) {
                if (pidFilter != null) {
                    redirect = redirect + "?pidFilter=" + pidFilter;
                }
                WebConsoleUtil.sendRedirect(request, response, redirect);
            } else {
                response.setContentType("text/plain");
                response.getWriter().print("true");
            }
            return;
        }
        if (config == null) {
            config = ConfigManager.getConfiguration(ca, pid);
        }
        if (request.getParameter("unbind") != null) {
            config.setBundleLocation(null);
            response.setContentType("text/plain");
            response.getWriter().print("true");
            return;
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        Locale loc = this.getLocale(request);
        String locale = loc != null ? loc.toString() : null;
        this.printConfigurationJson(response.getWriter(), pid, config, pidFilter, locale);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String pid = info.substring(info.lastIndexOf(47) + 1, info.length() - 5);
            String pidFilter = request.getParameter(PID_FILTER);
            if (pidFilter == null) {
                pidFilter = pid;
            }
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
            ConfigurationAdmin ca = this.getConfigurationAdmin();
            Locale loc = this.getLocale(request);
            String locale = loc != null ? loc.toString() : null;
            PrintWriter pw = response.getWriter();
            try {
                pw.write("[");
                SortedMap services = this.getServices(pid, pidFilter, locale, false);
                Iterator i = services.keySet().iterator();
                boolean printColon = false;
                while (i.hasNext()) {
                    String servicePid = i.next().toString();
                    Configuration config = ConfigManager.getConfiguration(ca, servicePid);
                    if (config == null) continue;
                    if (printColon) {
                        pw.print(',');
                    }
                    this.printConfigurationJson(pw, servicePid, config, pidFilter, locale);
                    printColon = true;
                }
                pw.write("]");
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pid = request.getPathInfo().substring(this.getLabel().length() + 1);
        pid = pid.length() == 0 ? null : pid.substring(pid.lastIndexOf(47) + 1);
        String pidFilter = request.getParameter(PID_FILTER);
        if (pidFilter == null) {
            pidFilter = pid;
        }
        if (pidFilter != null) {
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
        }
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        Locale loc = this.getLocale(request);
        String locale = loc != null ? loc.toString() : null;
        JSONObject json = new JSONObject();
        try {
            json.put("status", (Object)(ca != null ? Boolean.TRUE : Boolean.FALSE));
            if (ca != null) {
                this.listConfigurations(json, ca, pidFilter, locale, loc);
                this.listFactoryConfigurations(json, pidFilter, locale);
            }
        }
        catch (JSONException e) {
            throw new IOException(e.toString());
        }
        if (request.getParameter("create") != null && pid != null) {
            pid = new PlaceholderConfiguration(pid).getPid();
        }
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("__data__", json.toString());
        vars.put("selectedPid", pid != null ? pid : "");
        response.getWriter().print(this.TEMPLATE);
    }

    private static final Configuration getConfiguration(ConfigurationAdmin ca, String pid) {
        if (ca != null && pid != null) {
            try {
                String filter = "(service.pid=" + pid + ")";
                Configuration[] configs = ca.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    return configs[0];
                }
            }
            catch (InvalidSyntaxException ise) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private final void listFactoryConfigurations(JSONObject json, String pidFilter, String locale) {
        try {
            SortedMap optionsFactory = this.getServices((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), pidFilter, locale, true);
            this.addMetaTypeNames(optionsFactory, this.getFactoryPidObjectClasses(locale), pidFilter, "service.factoryPid");
            Iterator i = optionsFactory.keySet().iterator();
            while (i.hasNext()) {
                String id = (String)i.next();
                Object name = optionsFactory.get(id);
                json.append("fpids", (Object)new JSONObject().put("id", (Object)id).put("name", name));
            }
        }
        catch (Exception e) {
            this.log("listFactoryConfigurations: Unexpected problem encountered", e);
        }
    }

    private final void listConfigurations(JSONObject json, ConfigurationAdmin ca, String pidFilter, String locale, Locale loc) {
        try {
            SortedMap optionsPlain = this.getServices((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), pidFilter, locale, true);
            this.addMetaTypeNames(optionsPlain, this.getPidObjectClasses(locale), pidFilter, "service.pid");
            Configuration[] cfgs = ca.listConfigurations(pidFilter);
            for (int i = 0; cfgs != null && i < cfgs.length; ++i) {
                String pid = cfgs[i].getPid();
                if (optionsPlain.containsKey(pid)) continue;
                ObjectClassDefinition ocd = null;
                try {
                    ocd = this.getObjectClassDefinition(cfgs[i], locale);
                }
                catch (IllegalArgumentException t) {
                    // empty catch block
                }
                if (ocd == null) continue;
                optionsPlain.put(pid, ocd.getName());
            }
            Iterator i = optionsPlain.keySet().iterator();
            while (i.hasNext()) {
                String id = (String)i.next();
                Object name = optionsPlain.get(id);
                Configuration config = ConfigManager.getConfiguration(ca, id);
                JSONObject data = new JSONObject().put("id", (Object)id).put("name", name);
                if (null != config) {
                    Bundle bundle;
                    String fpid = config.getFactoryPid();
                    if (null != fpid) {
                        data.put("fpid", (Object)fpid);
                    }
                    if (null != (bundle = this.getBoundBundle(config))) {
                        data.put("bundle", bundle.getBundleId());
                        data.put("bundle_name", (Object)Util.getName(bundle, loc));
                    }
                }
                json.append("pids", (Object)data);
            }
        }
        catch (Exception e) {
            this.log("listConfigurations: Unexpected problem encountered", e);
        }
    }

    private final Bundle getBoundBundle(Configuration config) {
        if (null == config) {
            return null;
        }
        String location = config.getBundleLocation();
        if (null == location) {
            return null;
        }
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            if (!bundles[i].getLocation().equals(location)) continue;
            return bundles[i];
        }
        return null;
    }

    private SortedMap getServices(String serviceClass, String serviceFilter, String locale, boolean ocdRequired) throws InvalidSyntaxException {
        TreeMap<String, String> optionsFactory = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        ServiceReference[] refs = this.getBundleContext().getServiceReferences(serviceClass, serviceFilter);
        for (int i = 0; refs != null && i < refs.length; ++i) {
            Object pidObject = refs[i].getProperty("service.pid");
            if (!(pidObject instanceof String)) continue;
            String pid = (String)pidObject;
            ObjectClassDefinition ocd = this.getObjectClassDefinition(refs[i].getBundle(), pid, locale);
            String name = ocd != null ? ocd.getName() : pid;
            if (ocdRequired && ocd == null) continue;
            optionsFactory.put(pid, name);
        }
        return optionsFactory;
    }

    private void addMetaTypeNames(Map pidMap, Collection ocdCollection, String filterSpec, String type) {
        Filter filter = null;
        if (filterSpec != null) {
            try {
                filter = this.getBundleContext().createFilter(filterSpec);
            }
            catch (InvalidSyntaxException not_expected) {
                // empty catch block
            }
        }
        Iterator oci = ocdCollection.iterator();
        while (oci.hasNext()) {
            ObjectClassDefinition ocd = (ObjectClassDefinition)oci.next();
            String pid = ocd.getID();
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put(type, pid);
            if (filter != null && !filter.match(props)) continue;
            pidMap.put(pid, ocd.getName());
        }
    }

    private void printConfigurationJson(PrintWriter pw, String pid, Configuration config, String pidFilter, String locale) {
        JSONWriter result = new JSONWriter((Writer)pw);
        if (pid != null) {
            try {
                result.object();
                this.configForm(result, pid, config, pidFilter, locale);
                result.endObject();
            }
            catch (Exception e) {
                this.log("Error reading configuration PID " + pid, e);
            }
        }
    }

    private void configForm(JSONWriter json, String pid, Configuration config, String pidFilter, String locale) throws JSONException {
        ObjectClassDefinition ocd;
        json.key(PID);
        json.value((Object)pid);
        if (pidFilter != null) {
            json.key(PID_FILTER);
            json.value((Object)pidFilter);
        }
        Dictionary props = null;
        if (config != null) {
            props = config.getProperties();
            ocd = this.getObjectClassDefinition(config, locale);
        } else {
            ocd = this.getObjectClassDefinition(pid, locale);
        }
        props = this.mergeWithMetaType(props, ocd, json);
        if (props != null) {
            json.key("title");
            json.value((Object)pid);
            json.key("description");
            json.value((Object)"Please enter configuration properties for this configuration in the field below. This configuration has no associated description");
            json.key("propertylist");
            json.value((Object)"properties");
            json.key("properties");
            json.object();
            Enumeration pe = props.keys();
            while (pe.hasMoreElements()) {
                Object key = pe.nextElement();
                if (key.equals("service.pid") || key.equals("service.description") || key.equals("service.id") || key.equals("service.ranking") || key.equals("service.vendor") || key.equals("service.bundleLocation") || key.equals("service.factoryPid")) continue;
                json.key(String.valueOf(key));
                json.value(props.get(key));
            }
            json.endObject();
        }
        if (config != null) {
            this.addConfigurationInfo(config, json, locale);
        }
    }

    private Dictionary mergeWithMetaType(Dictionary props, ObjectClassDefinition ocd, JSONWriter json) throws JSONException {
        if (props == null) {
            props = new Hashtable();
        }
        if (ocd != null) {
            AttributeDefinition[] ad;
            json.key("title");
            json.value((Object)ocd.getName());
            if (ocd.getDescription() != null) {
                json.key("description");
                json.value((Object)ocd.getDescription());
            }
            if ((ad = ocd.getAttributeDefinitions(-1)) != null) {
                JSONArray propertyList = new JSONArray();
                for (int i = 0; i < ad.length; ++i) {
                    json.key(ad[i].getID());
                    json.object();
                    Object value = ((Dictionary)props).get(ad[i].getID());
                    if (value == null && (value = ad[i].getDefaultValue()) == null) {
                        value = ad[i].getCardinality() == 0 ? "" : new String[]{};
                    }
                    json.key("name");
                    json.value((Object)ad[i].getName());
                    json.key("type");
                    if (ad[i].getOptionLabels() != null && ad[i].getOptionLabels().length > 0) {
                        json.object();
                        json.key("labels");
                        json.value(Arrays.asList(ad[i].getOptionLabels()));
                        json.key("values");
                        json.value(Arrays.asList(ad[i].getOptionValues()));
                        json.endObject();
                    } else {
                        json.value((long)ad[i].getType());
                    }
                    if (ad[i].getCardinality() == 0) {
                        if (value instanceof Vector) {
                            value = ((Vector)value).get(0);
                        } else if (value.getClass().isArray()) {
                            value = Array.get(value, 0);
                        }
                        json.key("value");
                        json.value(value);
                    } else {
                        if (value instanceof Vector) {
                            value = new JSONArray((Collection)((Vector)value));
                        } else if (value.getClass().isArray()) {
                            if (value.getClass().getComponentType().isPrimitive()) {
                                int len = Array.getLength(value);
                                Object[] tmp = new Object[len];
                                for (int j = 0; j < len; ++j) {
                                    tmp[j] = Array.get(value, j);
                                }
                                value = tmp;
                            }
                            value = new JSONArray(Arrays.asList((Object[])value));
                        } else {
                            JSONArray tmp = new JSONArray();
                            tmp.put(value);
                            value = tmp;
                        }
                        json.key("values");
                        json.value(value);
                    }
                    if (ad[i].getDescription() != null) {
                        json.key("description");
                        json.value((Object)(ad[i].getDescription() + " (" + ad[i].getID() + ")"));
                    }
                    json.endObject();
                    propertyList.put((Object)ad[i].getID());
                }
                json.key("propertylist");
                json.value((Object)propertyList);
            }
            props = null;
        }
        return props;
    }

    private void addConfigurationInfo(Configuration config, JSONWriter json, String locale) throws JSONException {
        String location;
        if (config.getFactoryPid() != null) {
            json.key(factoryPID);
            json.value((Object)config.getFactoryPid());
        }
        if (config.getBundleLocation() == null) {
            location = "";
        } else {
            Bundle bundle = this.getBundle(config.getBundleLocation());
            if (bundle == null) {
                location = config.getBundleLocation();
            } else {
                Dictionary headers = bundle.getHeaders(locale);
                String name = (String)headers.get("Bundle-Name");
                location = name == null ? bundle.getSymbolicName() : name + " (" + bundle.getSymbolicName() + ")";
                Version v = Version.parseVersion((String)((String)headers.get("Bundle-Version")));
                location = location + ", Version " + v.toString();
            }
        }
        json.key("bundleLocation");
        json.value((Object)location);
        String pid = config.getPid();
        String serviceLocation = "";
        try {
            ServiceReference[] refs = this.getBundleContext().getServiceReferences(null, "(&(objectClass=" + (class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName() + ")(" + "service.pid" + '=' + pid + "))");
            if (refs != null && refs.length > 0) {
                serviceLocation = refs[0].getBundle().getLocation();
            }
        }
        catch (Throwable t) {
            this.log("Error getting service associated with configuration " + pid, t);
        }
        json.key("bundle_location");
        json.value((Object)config.getBundleLocation());
        json.key("service_location");
        json.value((Object)serviceLocation);
    }

    private String applyConfiguration(HttpServletRequest request, ConfigurationAdmin ca, String pid) throws IOException {
        if (request.getParameter("delete") != null) {
            if (!PLACEHOLDER_PID.equals(pid)) {
                this.log("applyConfiguration: Deleting configuration " + pid);
                Configuration config = ca.getConfiguration(pid, null);
                config.delete();
            }
            return null;
        }
        String factoryPid = request.getParameter(factoryPID);
        Configuration config = null;
        String propertyList = request.getParameter("propertylist");
        if (propertyList == null) {
            String propertiesString = request.getParameter("properties");
            if (propertiesString != null) {
                byte[] propBytes = propertiesString.getBytes("ISO-8859-1");
                ByteArrayInputStream bin = new ByteArrayInputStream(propBytes);
                Properties props = new Properties();
                props.load(bin);
                config = ConfigManager.getConfiguration(ca, pid, factoryPid);
                config.update((Dictionary)props);
            }
        } else {
            Map adMap;
            config = ConfigManager.getConfiguration(ca, pid, factoryPid);
            Hashtable<String, Object> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, Object>();
            }
            if ((adMap = this.getAttributeDefinitionMap(config, null)) != null) {
                StringTokenizer propTokens = new StringTokenizer(propertyList, ",");
                while (propTokens.hasMoreTokens()) {
                    String prop;
                    String propName = propTokens.nextToken();
                    AttributeDefinition ad = (AttributeDefinition)adMap.get(propName);
                    if (ad == null || ad.getCardinality() == 0 && ad.getType() == 1) {
                        prop = request.getParameter(propName);
                        if (prop == null) continue;
                        ((Dictionary)props).put(propName, prop);
                        continue;
                    }
                    if (ad.getCardinality() == 0) {
                        prop = request.getParameter(propName);
                        if (prop == null) continue;
                        try {
                            ((Dictionary)props).put(propName, ConfigManager.toType(ad.getType(), prop));
                        }
                        catch (NumberFormatException nfe) {}
                        continue;
                    }
                    Vector<Object> vec = new Vector<Object>();
                    String[] properties = request.getParameterValues(propName);
                    if (properties != null) {
                        for (int i = 0; i < properties.length; ++i) {
                            try {
                                vec.add(ConfigManager.toType(ad.getType(), properties[i]));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                        }
                    }
                    int maxSize = Math.abs(ad.getCardinality());
                    if (vec.size() > maxSize && maxSize > 0) {
                        vec.setSize(maxSize);
                    }
                    if (ad.getCardinality() < 0) {
                        ((Dictionary)props).put(propName, vec);
                        continue;
                    }
                    ((Dictionary)props).put(propName, ConfigManager.toArray(ad.getType(), vec));
                }
            }
            config.update(props);
        }
        return config != null ? config.getPid() : "";
    }

    private static final Configuration getConfiguration(ConfigurationAdmin ca, String pid, String factoryPid) throws IOException {
        if (factoryPid != null && (pid == null || pid.equals(PLACEHOLDER_PID))) {
            return ca.createFactoryConfiguration(factoryPid, null);
        }
        return ca.getConfiguration(pid, null);
    }

    private static final Object toType(int type, String value) {
        switch (type) {
            case 11: {
                return Boolean.valueOf(value);
            }
            case 6: {
                return Byte.valueOf(value);
            }
            case 5: {
                char c = value.length() > 0 ? value.charAt(0) : (char)'\u0000';
                return new Character(c);
            }
            case 7: {
                return Double.valueOf(value);
            }
            case 8: {
                return Float.valueOf(value);
            }
            case 2: {
                return Long.valueOf(value);
            }
            case 3: {
                return Integer.valueOf(value);
            }
            case 4: {
                return Short.valueOf(value);
            }
        }
        return value;
    }

    private static final Object toArray(int type, Vector values) {
        Object[] array;
        int size = values.size();
        if (type == 1) {
            return values.toArray(new String[size]);
        }
        switch (type) {
            case 11: {
                array = new boolean[size];
                break;
            }
            case 6: {
                array = new byte[size];
                break;
            }
            case 5: {
                array = new char[size];
                break;
            }
            case 7: {
                array = new double[size];
                break;
            }
            case 8: {
                array = new float[size];
                break;
            }
            case 2: {
                array = new long[size];
                break;
            }
            case 3: {
                array = new int[size];
                break;
            }
            case 4: {
                array = new short[size];
                break;
            }
            default: {
                array = new String[size];
            }
        }
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PlaceholderConfiguration
    implements Configuration {
        private final String factoryPid;
        private String bundleLocation;

        PlaceholderConfiguration(String factoryPid) {
            this.factoryPid = factoryPid;
        }

        public String getPid() {
            return ConfigManager.PLACEHOLDER_PID;
        }

        public String getFactoryPid() {
            return this.factoryPid;
        }

        public void setBundleLocation(String bundleLocation) {
            this.bundleLocation = bundleLocation;
        }

        public String getBundleLocation() {
            return this.bundleLocation;
        }

        public Dictionary getProperties() {
            return null;
        }

        public void update() {
        }

        public void update(Dictionary properties) {
        }

        public void delete() {
        }
    }
}

