/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.obr;

import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

public class OsgiDeployer
implements Runnable {
    private final Resolver obrResolver;
    private final AbstractWebConsolePlugin logger;
    private final boolean startBundles;

    static void deploy(Resolver obrResolver, AbstractWebConsolePlugin logger, boolean startBundles) {
        OsgiDeployer d = new OsgiDeployer(obrResolver, logger, startBundles);
        Thread t = new Thread((Runnable)d, "OBR Bundle Deployer (OSGi API)");
        t.start();
    }

    public OsgiDeployer(Resolver obrResolver, AbstractWebConsolePlugin logger, boolean startBundles) {
        this.obrResolver = obrResolver;
        this.logger = logger;
        this.startBundles = startBundles;
    }

    public void run() {
        try {
            if (this.obrResolver.resolve()) {
                OsgiDeployer.logResource(this.logger, "Installing Requested Resources", this.obrResolver.getAddedResources());
                OsgiDeployer.logResource(this.logger, "Installing Required Resources", this.obrResolver.getRequiredResources());
                OsgiDeployer.logResource(this.logger, "Installing Optional Resources", this.obrResolver.getOptionalResources());
                this.obrResolver.deploy(this.startBundles);
            } else {
                OsgiDeployer.logRequirements(this.logger, "Cannot Install requested bundles due to unsatisfied requirements", this.obrResolver.getUnsatisfiedRequirements());
            }
        }
        catch (Exception ie) {
            this.logger.log(1, "Cannot install bundles", ie);
        }
    }

    public static void logResource(AbstractWebConsolePlugin logger, String message, Resource[] res) {
        if (res != null && res.length > 0) {
            logger.log(3, message);
            for (int i = 0; i < res.length; ++i) {
                logger.log(3, "  " + i + ": " + res[i].getSymbolicName() + ", " + res[i].getVersion());
            }
        }
    }

    public static void logRequirements(AbstractWebConsolePlugin logger, String message, Requirement[] reasons) {
        logger.log(1, message);
        for (int i = 0; reasons != null && i < reasons.length; ++i) {
            String moreInfo = reasons[i].getComment();
            if (moreInfo == null) {
                moreInfo = reasons[i].getFilter().toString();
            }
            logger.log(1, "  " + i + ": " + reasons[i].getName() + " (" + moreInfo + ")");
        }
    }
}

