/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.type.Type;

public class CacheKey
implements Serializable {
    private final Serializable key;
    private final Type type;
    private final String entityOrRoleName;
    private final EntityMode entityMode;
    private final String tenantId;
    private final int hashCode;

    public CacheKey(Serializable id, Type type, String entityOrRoleName, EntityMode entityMode, String tenantId, SessionFactoryImplementor factory) {
        this.key = id;
        this.type = type;
        this.entityOrRoleName = entityOrRoleName;
        this.entityMode = entityMode;
        this.tenantId = tenantId;
        this.hashCode = type.getHashCode(this.key, entityMode, factory);
    }

    public String toString() {
        return this.entityOrRoleName + '#' + this.key.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CacheKey)) {
            return false;
        }
        CacheKey that = (CacheKey)other;
        return this.entityOrRoleName.equals(that.entityOrRoleName) && this.type.isEqual(this.key, that.key, this.entityMode) && EqualsHelper.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Serializable getKey() {
        return this.key;
    }

    public String getEntityOrRoleName() {
        return this.entityOrRoleName;
    }
}

