/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.Collections;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.type.CollectionType;

public class FlushVisitor
extends AbstractVisitor {
    private Object owner;

    @Override
    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection == CollectionType.UNFETCHED_COLLECTION) {
            return null;
        }
        if (collection != null) {
            PersistentCollection coll = type.hasHolder(this.getSession().getEntityMode()) ? this.getSession().getPersistenceContext().getCollectionHolder(collection) : (PersistentCollection)collection;
            Collections.processReachableCollection(coll, type, this.owner, this.getSession());
        }
        return null;
    }

    FlushVisitor(EventSource session, Object owner) {
        super(session);
        this.owner = owner;
    }
}

