/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.HashMap;
import java.util.Map;

public enum CascadeType {
    ALL,
    ALL_DELETE_ORPHAN,
    UPDATE,
    PERSIST,
    MERGE,
    LOCK,
    REFRESH,
    REPLICATE,
    EVICT,
    DELETE,
    DELETE_ORPHAN,
    NONE;

    private static final Map<String, CascadeType> hbmOptionToCascadeType;
    private static final Map<javax.persistence.CascadeType, CascadeType> jpaCascadeTypeToHibernateCascadeType;

    public static CascadeType getCascadeType(String hbmOptionName) {
        return hbmOptionToCascadeType.get(hbmOptionName);
    }

    public static CascadeType getCascadeType(javax.persistence.CascadeType jpaCascade) {
        return jpaCascadeTypeToHibernateCascadeType.get(jpaCascade);
    }

    static {
        hbmOptionToCascadeType = new HashMap<String, CascadeType>();
        hbmOptionToCascadeType.put("all", ALL);
        hbmOptionToCascadeType.put("all-delete-orphan", ALL_DELETE_ORPHAN);
        hbmOptionToCascadeType.put("save-update", UPDATE);
        hbmOptionToCascadeType.put("persist", PERSIST);
        hbmOptionToCascadeType.put("merge", MERGE);
        hbmOptionToCascadeType.put("lock", LOCK);
        hbmOptionToCascadeType.put("refresh", REFRESH);
        hbmOptionToCascadeType.put("replicate", REPLICATE);
        hbmOptionToCascadeType.put("evict", EVICT);
        hbmOptionToCascadeType.put("delete", DELETE);
        hbmOptionToCascadeType.put("remove", DELETE);
        hbmOptionToCascadeType.put("delete-orphan", DELETE_ORPHAN);
        hbmOptionToCascadeType.put("none", NONE);
        jpaCascadeTypeToHibernateCascadeType = new HashMap<javax.persistence.CascadeType, CascadeType>();
        jpaCascadeTypeToHibernateCascadeType.put(javax.persistence.CascadeType.ALL, ALL);
        jpaCascadeTypeToHibernateCascadeType.put(javax.persistence.CascadeType.PERSIST, PERSIST);
        jpaCascadeTypeToHibernateCascadeType.put(javax.persistence.CascadeType.MERGE, MERGE);
        jpaCascadeTypeToHibernateCascadeType.put(javax.persistence.CascadeType.REFRESH, REFRESH);
        jpaCascadeTypeToHibernateCascadeType.put(javax.persistence.CascadeType.DETACH, EVICT);
    }
}

