/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import org.hibernate.metamodel.binding.BasicCollectionElement;
import org.hibernate.metamodel.binding.CollectionElement;
import org.hibernate.metamodel.binding.CompositeCollectionElement;
import org.hibernate.metamodel.binding.ManyToAnyCollectionElement;
import org.hibernate.metamodel.binding.ManyToManyCollectionElement;
import org.hibernate.metamodel.binding.OneToManyCollectionElement;
import org.hibernate.metamodel.binding.PluralAttributeBinding;

public enum CollectionElementType {
    BASIC("basic"){

        @Override
        public CollectionElement createCollectionElementInternal(PluralAttributeBinding attributeBinding) {
            return new BasicCollectionElement(attributeBinding);
        }
    }
    ,
    COMPOSITE("composite"){

        @Override
        public CollectionElement createCollectionElementInternal(PluralAttributeBinding attributeBinding) {
            return new CompositeCollectionElement(attributeBinding);
        }
    }
    ,
    ONE_TO_MANY("one-to-many"){

        @Override
        public boolean isOneToMany() {
            return true;
        }

        @Override
        public CollectionElement createCollectionElementInternal(PluralAttributeBinding attributeBinding) {
            return new OneToManyCollectionElement(attributeBinding);
        }
    }
    ,
    MANY_TO_MANY("many-to-many"){

        @Override
        public boolean isManyToMany() {
            return true;
        }

        @Override
        public CollectionElement createCollectionElementInternal(PluralAttributeBinding attributeBinding) {
            return new ManyToManyCollectionElement(attributeBinding);
        }
    }
    ,
    MANY_TO_ANY("many-to-any"){

        @Override
        public boolean isManyToAny() {
            return true;
        }

        @Override
        public CollectionElement createCollectionElementInternal(PluralAttributeBinding attributeBinding) {
            return new ManyToAnyCollectionElement(attributeBinding);
        }
    };

    private final String name;

    private CollectionElementType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToAny() {
        return false;
    }

    protected abstract CollectionElement createCollectionElementInternal(PluralAttributeBinding var1);

    CollectionElement createCollectionElement(PluralAttributeBinding attributeBinding) {
        CollectionElement collectionElement = this.createCollectionElementInternal(attributeBinding);
        if (collectionElement.getCollectionElementType() != this) {
            throw new IllegalStateException("Collection element has unexpected type nature: actual=[" + (Object)((Object)collectionElement.getCollectionElementType()) + "; expected=[" + (Object)((Object)this) + "]");
        }
        return collectionElement;
    }
}

