/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.metamodel.relational.AbstractTableSpecification;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.ObjectName;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.UniqueKey;
import org.hibernate.metamodel.relational.ValueContainer;

public class Table
extends AbstractTableSpecification
implements ValueContainer,
Exportable {
    private final Schema database;
    private final Identifier tableName;
    private final String qualifiedName;
    private List<Index> indexes;
    private List<UniqueKey> uniqueKeys;
    private List<String> checkConstraints;
    private Set<String> comments;

    public Table(Schema database, String tableName) {
        this(database, Identifier.toIdentifier(tableName));
    }

    public Table(Schema database, Identifier tableName) {
        this.database = database;
        this.tableName = tableName;
        ObjectName objectName = new ObjectName(database.getName().getSchema(), database.getName().getCatalog(), tableName);
        this.qualifiedName = objectName.toText();
    }

    @Override
    public Schema getSchema() {
        return this.database;
    }

    public Identifier getTableName() {
        return this.tableName;
    }

    @Override
    public String getLoggableValueQualifier() {
        return this.qualifiedName;
    }

    @Override
    public String getExportIdentifier() {
        return this.qualifiedName;
    }

    @Override
    public String toLoggableString() {
        return this.qualifiedName;
    }

    @Override
    public Iterable<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index getOrCreateIndex(String name) {
        Index index = new Index(this, name);
        if (this.indexes == null) {
            this.indexes = new ArrayList<Index>();
        }
        this.indexes.add(index);
        return index;
    }

    @Override
    public Iterable<UniqueKey> getUniqueKeys() {
        return this.uniqueKeys;
    }

    @Override
    public UniqueKey getOrCreateUniqueKey(String name) {
        UniqueKey uniqueKey = new UniqueKey(this, name);
        if (this.uniqueKeys == null) {
            this.uniqueKeys = new ArrayList<UniqueKey>();
        }
        this.uniqueKeys.add(uniqueKey);
        return uniqueKey;
    }

    @Override
    public Iterable<String> getCheckConstraints() {
        return this.checkConstraints;
    }

    @Override
    public void addCheckConstraint(String checkCondition) {
        if (this.checkConstraints == null) {
            this.checkConstraints = new ArrayList<String>();
        }
        this.checkConstraints.add(checkCondition);
    }

    @Override
    public Iterable<String> getComments() {
        return this.comments;
    }

    @Override
    public void addComment(String comment) {
        if (this.comments == null) {
            this.comments = new HashSet<String>();
        }
        this.comments.add(comment);
    }

    public String toString() {
        return "Table{name=" + this.qualifiedName + '}';
    }
}

