/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.entity.AssociationType;
import org.hibernate.metamodel.source.annotations.entity.SimpleAttribute;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class AssociationAttribute
extends SimpleAttribute {
    private final AssociationType associationType;
    private final boolean ignoreNotFound;
    private final String referencedEntityType;
    private final Set<CascadeType> cascadeTypes;

    public static AssociationAttribute createAssociationAttribute(String name, String type, AssociationType associationType, Map<DotName, List<AnnotationInstance>> annotations) {
        return new AssociationAttribute(name, type, associationType, annotations);
    }

    private AssociationAttribute(String name, String type, AssociationType associationType, Map<DotName, List<AnnotationInstance>> annotations) {
        super(name, type, annotations, false);
        this.associationType = associationType;
        this.ignoreNotFound = this.ignoreNotFound();
        AnnotationInstance associationAnnotation = JandexHelper.getSingleAnnotation(annotations, associationType.getAnnotationDotName());
        this.referencedEntityType = this.determineReferencedEntityType(associationAnnotation);
        this.cascadeTypes = this.determineCascadeTypes(associationAnnotation);
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public String getReferencedEntityType() {
        return this.referencedEntityType;
    }

    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public Set<CascadeType> getCascadeTypes() {
        return this.cascadeTypes;
    }

    private boolean ignoreNotFound() {
        AnnotationValue actionValue;
        NotFoundAction action = NotFoundAction.EXCEPTION;
        AnnotationInstance notFoundAnnotation = this.getIfExists(HibernateDotNames.NOT_FOUND);
        if (notFoundAnnotation != null && (actionValue = notFoundAnnotation.value("action")) != null) {
            action = Enum.valueOf(NotFoundAction.class, actionValue.asEnum());
        }
        return NotFoundAction.IGNORE.equals((Object)action);
    }

    private String determineReferencedEntityType(AnnotationInstance associationAnnotation) {
        AnnotationValue targetEntityValue;
        String targetTypeName = this.getType();
        AnnotationInstance targetAnnotation = this.getIfExists(HibernateDotNames.TARGET);
        if (targetAnnotation != null) {
            targetTypeName = targetAnnotation.value().asClass().name().toString();
        }
        if ((targetEntityValue = associationAnnotation.value("targetEntity")) != null) {
            targetTypeName = targetEntityValue.asClass().name().toString();
        }
        return targetTypeName;
    }

    private Set<CascadeType> determineCascadeTypes(AnnotationInstance associationAnnotation) {
        HashSet<CascadeType> cascadeTypes = new HashSet<CascadeType>();
        AnnotationValue cascadeValue = associationAnnotation.value("cascade");
        if (cascadeValue != null) {
            String[] cascades;
            for (String s : cascades = cascadeValue.asEnumArray()) {
                cascadeTypes.add(Enum.valueOf(CascadeType.class, s));
            }
        }
        return cascadeTypes;
    }
}

