/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashSet;
import org.hibernate.MappingException;
import org.hibernate.annotations.FetchMode;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Index;

public class FetchProfileBinder {
    public static void bind(MetadataImplementor metadata, Index jandex) {
        for (AnnotationInstance fetchProfile : jandex.getAnnotations(HibernateDotNames.FETCH_PROFILE)) {
            FetchProfileBinder.bind(metadata, fetchProfile);
        }
        for (AnnotationInstance fetchProfiles : jandex.getAnnotations(HibernateDotNames.FETCH_PROFILES)) {
            for (AnnotationInstance fetchProfile : JandexHelper.getValueAsArray(fetchProfiles, "value")) {
                FetchProfileBinder.bind(metadata, fetchProfile);
            }
        }
    }

    private static void bind(MetadataImplementor metadata, AnnotationInstance fetchProfile) {
        String name = JandexHelper.getValueAsString(fetchProfile, "name");
        HashSet<FetchProfile.Fetch> fetches = new HashSet<FetchProfile.Fetch>();
        for (AnnotationInstance override : JandexHelper.getValueAsArray(fetchProfile, "fetchOverrides")) {
            FetchMode fetchMode = JandexHelper.getValueAsEnum(override, "mode", FetchMode.class);
            if (!fetchMode.equals((Object)FetchMode.JOIN)) {
                throw new MappingException("Only FetchMode.JOIN is currently supported");
            }
            fetches.add(new FetchProfile.Fetch(JandexHelper.getValueAsString(override, "entity"), JandexHelper.getValueAsString(override, "association"), fetchMode.toString().toLowerCase()));
        }
        metadata.addFetchProfile(new FetchProfile(name, fetches));
    }

    private FetchProfileBinder() {
    }
}

