/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashMap;
import org.hibernate.AnnotationException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;

public class QueryBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)QueryBinder.class.getName());

    public static void bind(MetadataImplementor metadata, Index jandex) {
        for (AnnotationInstance query : jandex.getAnnotations(JPADotNames.NAMED_QUERY)) {
            QueryBinder.bindNamedQuery(metadata, query);
        }
        for (AnnotationInstance queries : jandex.getAnnotations(JPADotNames.NAMED_QUERIES)) {
            for (AnnotationInstance query : JandexHelper.getValueAsArray(queries, "value")) {
                QueryBinder.bindNamedQuery(metadata, query);
            }
        }
        for (AnnotationInstance query : jandex.getAnnotations(JPADotNames.NAMED_NATIVE_QUERY)) {
            QueryBinder.bindNamedNativeQuery(metadata, query);
        }
        for (AnnotationInstance queries : jandex.getAnnotations(JPADotNames.NAMED_NATIVE_QUERIES)) {
            for (AnnotationInstance query : JandexHelper.getValueAsArray(queries, "value")) {
                QueryBinder.bindNamedNativeQuery(metadata, query);
            }
        }
        for (AnnotationInstance query : jandex.getAnnotations(HibernateDotNames.NAMED_QUERY)) {
            QueryBinder.bindNamedQuery(metadata, query);
        }
        for (AnnotationInstance queries : jandex.getAnnotations(HibernateDotNames.NAMED_QUERIES)) {
            for (AnnotationInstance query : JandexHelper.getValueAsArray(queries, "value")) {
                QueryBinder.bindNamedQuery(metadata, query);
            }
        }
        for (AnnotationInstance query : jandex.getAnnotations(HibernateDotNames.NAMED_NATIVE_QUERY)) {
            QueryBinder.bindNamedNativeQuery(metadata, query);
        }
        for (AnnotationInstance queries : jandex.getAnnotations(HibernateDotNames.NAMED_NATIVE_QUERIES)) {
            for (AnnotationInstance query : JandexHelper.getValueAsArray(queries, "value")) {
                QueryBinder.bindNamedNativeQuery(metadata, query);
            }
        }
    }

    private static void bindNamedQuery(MetadataImplementor metadata, AnnotationInstance annotation) {
        String comment;
        Integer fetchSize;
        Integer timeout;
        String name = JandexHelper.getValueAsString(annotation, "name");
        if (StringHelper.isEmpty(name)) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String query = JandexHelper.getValueAsString(annotation, "query");
        AnnotationInstance[] hints = JandexHelper.getValueAsArray(annotation, "hints");
        String cacheRegion = QueryBinder.getString(hints, "org.hibernate.cacheRegion");
        if (StringHelper.isEmpty(cacheRegion)) {
            cacheRegion = null;
        }
        if ((timeout = QueryBinder.getTimeout(hints, query)) != null && timeout < 0) {
            timeout = null;
        }
        if ((fetchSize = QueryBinder.getInteger(hints, "org.hibernate.fetchSize", name)) != null && fetchSize < 0) {
            fetchSize = null;
        }
        if (StringHelper.isEmpty(comment = QueryBinder.getString(hints, "org.hibernate.comment"))) {
            comment = null;
        }
        metadata.addNamedQuery(new NamedQueryDefinition(name, query, QueryBinder.getBoolean(hints, "org.hibernate.cacheable", name), cacheRegion, timeout, fetchSize, QueryBinder.getFlushMode(hints, "org.hibernate.flushMode", name), QueryBinder.getCacheMode(hints, "org.hibernate.cacheMode", name), QueryBinder.getBoolean(hints, "org.hibernate.readOnly", name), comment, null));
        LOG.debugf("Binding named query: %s => %s", name, query);
    }

    private static void bindNamedNativeQuery(MetadataImplementor metadata, AnnotationInstance annotation) {
        NamedSQLQueryDefinition def;
        Integer fetchSize;
        Integer timeout;
        String name = JandexHelper.getValueAsString(annotation, "name");
        if (StringHelper.isEmpty(name)) {
            throw new AnnotationException("A named native query must have a name when used in class or package level");
        }
        String query = JandexHelper.getValueAsString(annotation, "query");
        String resultSetMapping = JandexHelper.getValueAsString(annotation, "resultSetMapping");
        AnnotationInstance[] hints = JandexHelper.getValueAsArray(annotation, "hints");
        boolean cacheable = QueryBinder.getBoolean(hints, "org.hibernate.cacheable", name);
        String cacheRegion = QueryBinder.getString(hints, "org.hibernate.cacheRegion");
        if (StringHelper.isEmpty(cacheRegion)) {
            cacheRegion = null;
        }
        if ((timeout = QueryBinder.getTimeout(hints, query)) != null && timeout < 0) {
            timeout = null;
        }
        if ((fetchSize = QueryBinder.getInteger(hints, "org.hibernate.fetchSize", name)) != null && fetchSize < 0) {
            fetchSize = null;
        }
        FlushMode flushMode = QueryBinder.getFlushMode(hints, "org.hibernate.flushMode", name);
        CacheMode cacheMode = QueryBinder.getCacheMode(hints, "org.hibernate.cacheMode", name);
        boolean readOnly = QueryBinder.getBoolean(hints, "org.hibernate.readOnly", name);
        String comment = QueryBinder.getString(hints, "org.hibernate.comment");
        if (StringHelper.isEmpty(comment)) {
            comment = null;
        }
        boolean callable = QueryBinder.getBoolean(hints, "org.hibernate.callable", name);
        if (StringHelper.isNotEmpty(resultSetMapping)) {
            def = new NamedSQLQueryDefinition(name, query, resultSetMapping, null, cacheable, cacheRegion, timeout, fetchSize, flushMode, cacheMode, readOnly, comment, null, callable);
        } else {
            String resultClass = JandexHelper.getValueAsString(annotation, "resultClass");
            if (Void.TYPE.equals(resultClass)) {
                throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
            }
            def = new NamedSQLQueryDefinition(name, query, new NativeSQLQueryRootReturn[]{new NativeSQLQueryRootReturn("alias1", resultClass, new HashMap<String, String[]>(), LockMode.READ)}, null, cacheable, cacheRegion, timeout, fetchSize, flushMode, cacheMode, readOnly, comment, null, callable);
        }
        metadata.addNamedNativeQuery(def);
        LOG.debugf("Binding named native query: %s => %s", name, query);
    }

    private static boolean getBoolean(AnnotationInstance[] hints, String element, String query) {
        String val = QueryBinder.getString(hints, element);
        if (val == null || val.equalsIgnoreCase("false")) {
            return false;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        throw new AnnotationException("Not a boolean in hint: " + query + ":" + element);
    }

    private static CacheMode getCacheMode(AnnotationInstance[] hints, String element, String query) {
        String val = QueryBinder.getString(hints, element);
        if (val == null) {
            return null;
        }
        if (val.equalsIgnoreCase(CacheMode.GET.toString())) {
            return CacheMode.GET;
        }
        if (val.equalsIgnoreCase(CacheMode.IGNORE.toString())) {
            return CacheMode.IGNORE;
        }
        if (val.equalsIgnoreCase(CacheMode.NORMAL.toString())) {
            return CacheMode.NORMAL;
        }
        if (val.equalsIgnoreCase(CacheMode.PUT.toString())) {
            return CacheMode.PUT;
        }
        if (val.equalsIgnoreCase(CacheMode.REFRESH.toString())) {
            return CacheMode.REFRESH;
        }
        throw new AnnotationException("Unknown CacheMode in hint: " + query + ":" + element);
    }

    private static FlushMode getFlushMode(AnnotationInstance[] hints, String element, String query) {
        String val = QueryBinder.getString(hints, element);
        if (val == null) {
            return null;
        }
        if (val.equalsIgnoreCase(FlushMode.ALWAYS.toString())) {
            return FlushMode.ALWAYS;
        }
        if (val.equalsIgnoreCase(FlushMode.AUTO.toString())) {
            return FlushMode.AUTO;
        }
        if (val.equalsIgnoreCase(FlushMode.COMMIT.toString())) {
            return FlushMode.COMMIT;
        }
        if (val.equalsIgnoreCase(FlushMode.NEVER.toString())) {
            return FlushMode.MANUAL;
        }
        if (val.equalsIgnoreCase(FlushMode.MANUAL.toString())) {
            return FlushMode.MANUAL;
        }
        throw new AnnotationException("Unknown FlushMode in hint: " + query + ":" + element);
    }

    private static Integer getInteger(AnnotationInstance[] hints, String element, String query) {
        String val = QueryBinder.getString(hints, element);
        if (val == null) {
            return null;
        }
        try {
            return Integer.decode(val);
        }
        catch (NumberFormatException nfe) {
            throw new AnnotationException("Not an integer in hint: " + query + ":" + element, nfe);
        }
    }

    private static String getString(AnnotationInstance[] hints, String element) {
        for (AnnotationInstance hint : hints) {
            if (!element.equals(JandexHelper.getValue(hint, "name"))) continue;
            return JandexHelper.getValueAsString(hint, "value");
        }
        return null;
    }

    private static Integer getTimeout(AnnotationInstance[] hints, String query) {
        Integer timeout = QueryBinder.getInteger(hints, "javax.persistence.query.timeout", query);
        if (timeout == null) {
            return QueryBinder.getInteger(hints, "org.hibernate.timeout", query);
        }
        return new Integer((int)Math.round(timeout.doubleValue() / 1000.0));
    }

    private QueryBinder() {
    }
}

