/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.TypeDef;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;

public class TypeDefBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TypeDefBinder.class.getName());

    public static void bind(MetadataImplementor metadata, Index jandex) {
        for (AnnotationInstance typeDef : jandex.getAnnotations(HibernateDotNames.TYPE_DEF)) {
            TypeDefBinder.bind(metadata, typeDef);
        }
        for (AnnotationInstance typeDefs : jandex.getAnnotations(HibernateDotNames.TYPE_DEFS)) {
            for (AnnotationInstance typeDef : JandexHelper.getValueAsArray(typeDefs, "value")) {
                TypeDefBinder.bind(metadata, typeDef);
            }
        }
    }

    private static void bind(MetadataImplementor metadata, AnnotationInstance typeDef) {
        boolean noDefaultForType;
        String name = JandexHelper.getValueAsString(typeDef, "name");
        String defaultForType = JandexHelper.getValueAsString(typeDef, "defaultForType");
        String typeClass = JandexHelper.getValueAsString(typeDef, "typeClass");
        boolean noName = StringHelper.isEmpty(name);
        boolean bl = noDefaultForType = defaultForType == null || defaultForType.equals(Void.TYPE.getName());
        if (noName && noDefaultForType) {
            throw new AnnotationException("Either name or defaultForType (or both) attribute should be set in TypeDef having typeClass " + typeClass);
        }
        HashMap<String, String> prms = new HashMap<String, String>();
        for (AnnotationInstance prm : JandexHelper.getValueAsArray(typeDef, "parameters")) {
            prms.put(JandexHelper.getValueAsString(prm, "name"), JandexHelper.getValueAsString(prm, "value"));
        }
        if (!noName) {
            TypeDefBinder.bind(name, typeClass, prms, metadata);
        }
        if (!noDefaultForType) {
            TypeDefBinder.bind(defaultForType, typeClass, prms, metadata);
        }
    }

    private static void bind(String name, String typeClass, Map<String, String> prms, MetadataImplementor metadata) {
        LOG.debugf("Binding type definition: %s", name);
        metadata.addTypeDefinition(new TypeDef(name, typeClass, prms));
    }

    private TypeDefBinder() {
    }
}

