/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.util;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;

public class JandexHelper {
    private static final AnnotationInstance[] EMPTY_ANNOTATIONS_ARRAY = new AnnotationInstance[0];
    private static final Map<String, Object> DEFAULT_VALUES_BY_ELEMENT = new HashMap<String, Object>();

    private static Object getDefaultValue(AnnotationInstance annotation, String element) {
        String name = annotation.name().toString();
        String fqElement = name + '.' + element;
        Object val = DEFAULT_VALUES_BY_ELEMENT.get(fqElement);
        if (val != null) {
            return val;
        }
        try {
            val = Index.class.getClassLoader().loadClass(name).getMethod(element, new Class[0]).getDefaultValue();
            DEFAULT_VALUES_BY_ELEMENT.put(fqElement, val);
            return val == null ? null : val;
        }
        catch (RuntimeException error) {
            throw error;
        }
        catch (Exception error) {
            throw new AnnotationException(error);
        }
    }

    public static String getPropertyName(AnnotationTarget target) {
        String propertyName;
        if (!(target instanceof MethodInfo) && !(target instanceof FieldInfo)) {
            throw new AssertionFailure("Unexpected annotation target " + target.toString());
        }
        if (target instanceof FieldInfo) {
            return ((FieldInfo)target).name();
        }
        String methodName = ((MethodInfo)target).name();
        if (methodName.startsWith("is")) {
            propertyName = Introspector.decapitalize(methodName.substring(2));
        } else if (methodName.startsWith("has")) {
            propertyName = Introspector.decapitalize(methodName.substring(3));
        } else if (methodName.startsWith("get")) {
            propertyName = Introspector.decapitalize(methodName.substring(3));
        } else {
            throw new AssertionFailure("Expected a method following the Java Bean notation");
        }
        return propertyName;
    }

    public static AnnotationInstance getSingleAnnotation(ClassInfo classInfo, DotName annotationName) throws AssertionFailure {
        return JandexHelper.getSingleAnnotation(classInfo.annotations(), annotationName);
    }

    public static AnnotationInstance getSingleAnnotation(Map<DotName, List<AnnotationInstance>> annotations, DotName annotationName) throws AssertionFailure {
        List<AnnotationInstance> annotationList = annotations.get(annotationName);
        if (annotationList == null) {
            return null;
        }
        if (annotationList.size() == 1) {
            return annotationList.get(0);
        }
        throw new AssertionFailure("Found more than one instance of the annotation " + annotationList.get(0).name().toString() + ". Expected was one.");
    }

    public static Object getValue(AnnotationInstance annotation, String element) {
        AnnotationValue val = annotation.value(element);
        if (val == null) {
            return JandexHelper.getDefaultValue(annotation, element);
        }
        return val.asNested();
    }

    public static AnnotationInstance[] getValueAsArray(AnnotationInstance annotation, String element) {
        AnnotationValue val = annotation.value(element);
        return val == null ? EMPTY_ANNOTATIONS_ARRAY : val.asNestedArray();
    }

    public static <T extends Enum<T>> T getValueAsEnum(AnnotationInstance annotation, String element, Class<T> type) {
        AnnotationValue val = annotation.value(element);
        if (val == null) {
            return (T)((Enum)JandexHelper.getDefaultValue(annotation, element));
        }
        return Enum.valueOf(type, val.asEnum());
    }

    public static int getValueAsInt(AnnotationInstance annotation, String element) {
        AnnotationValue val = annotation.value(element);
        if (val == null) {
            return (Integer)JandexHelper.getDefaultValue(annotation, element);
        }
        return val.asInt();
    }

    public static String getValueAsString(AnnotationInstance annotation, String element) {
        AnnotationValue val = annotation.value(element);
        if (val == null) {
            return (String)JandexHelper.getDefaultValue(annotation, element);
        }
        return val.asString();
    }

    public static Index indexForClass(ClassLoaderService classLoaderService, Class<?> ... classes) {
        Indexer indexer = new Indexer();
        for (Class<?> clazz : classes) {
            InputStream stream = classLoaderService.locateResourceStream(clazz.getName().replace('.', '/') + ".class");
            try {
                indexer.index(stream);
            }
            catch (IOException e) {
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                int count = 0;
                for (Class<?> c : classes) {
                    builder.append(c.getName());
                    if (count < classes.length - 1) {
                        builder.append(",");
                    }
                    ++count;
                }
                builder.append("]");
                throw new HibernateException("Unable to create annotation index for " + builder.toString());
            }
        }
        return indexer.complete();
    }

    public static Map<DotName, List<AnnotationInstance>> getMemberAnnotations(ClassInfo classInfo, String name) {
        if (classInfo == null) {
            throw new IllegalArgumentException("classInfo cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        HashMap<DotName, List<AnnotationInstance>> annotations = new HashMap<DotName, List<AnnotationInstance>>();
        for (List annotationList : classInfo.annotations().values()) {
            for (AnnotationInstance instance : annotationList) {
                String targetName = null;
                if (instance.target() instanceof FieldInfo) {
                    targetName = ((FieldInfo)instance.target()).name();
                } else if (instance.target() instanceof MethodInfo) {
                    targetName = ((MethodInfo)instance.target()).name();
                }
                if (targetName == null || !name.equals(targetName)) continue;
                JandexHelper.addAnnotationToMap(instance, annotations);
            }
        }
        return annotations;
    }

    public static Map<DotName, List<AnnotationInstance>> getTypeAnnotations(ClassInfo classInfo) {
        if (classInfo == null) {
            throw new IllegalArgumentException("classInfo cannot be null");
        }
        HashMap<DotName, List<AnnotationInstance>> annotations = new HashMap<DotName, List<AnnotationInstance>>();
        for (List annotationList : classInfo.annotations().values()) {
            for (AnnotationInstance instance : annotationList) {
                if (!(instance.target() instanceof ClassInfo)) continue;
                JandexHelper.addAnnotationToMap(instance, annotations);
            }
        }
        return annotations;
    }

    public static void addAnnotationToMap(AnnotationInstance instance, Map<DotName, List<AnnotationInstance>> annotations) {
        List<Object> list;
        DotName dotName = instance.name();
        if (annotations.containsKey(dotName)) {
            list = annotations.get(dotName);
        } else {
            list = new ArrayList();
            annotations.put(dotName, list);
        }
        list.add(instance);
    }

    private JandexHelper() {
    }
}

