/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import org.hibernate.MappingException;
import org.hibernate.metamodel.source.annotation.xml.XMLEntityListener;
import org.hibernate.metamodel.source.annotation.xml.XMLEntityListeners;
import org.hibernate.metamodel.source.annotation.xml.XMLPostLoad;
import org.hibernate.metamodel.source.annotation.xml.XMLPostPersist;
import org.hibernate.metamodel.source.annotation.xml.XMLPostRemove;
import org.hibernate.metamodel.source.annotation.xml.XMLPostUpdate;
import org.hibernate.metamodel.source.annotation.xml.XMLPrePersist;
import org.hibernate.metamodel.source.annotation.xml.XMLPreRemove;
import org.hibernate.metamodel.source.annotation.xml.XMLPreUpdate;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

class ListenerMocker
extends AbstractMocker {
    private final ClassInfo classInfo;

    ListenerMocker(IndexBuilder indexBuilder, ClassInfo classInfo) {
        super(indexBuilder);
        this.classInfo = classInfo;
    }

    AnnotationInstance parser(XMLEntityListeners entityListeners) {
        if (entityListeners.getEntityListener().isEmpty()) {
            throw new MappingException("No child element of <entity-listener> found under <entity-listeners>.");
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>(1);
        ArrayList<String> clazzNameList = new ArrayList<String>(entityListeners.getEntityListener().size());
        for (XMLEntityListener listener : entityListeners.getEntityListener()) {
            MockHelper.addToCollectionIfNotNull(clazzNameList, listener.getClazz());
            this.parserEntityListener(listener);
        }
        MockHelper.classArrayValue("value", clazzNameList, annotationValueList, this.indexBuilder.getServiceRegistry());
        return this.create(ENTITY_LISTENERS, (AnnotationTarget)this.classInfo, annotationValueList);
    }

    private void parserEntityListener(XMLEntityListener listener) {
        String clazz = listener.getClazz();
        ClassInfo tempClassInfo = this.indexBuilder.createClassInfo(clazz);
        ListenerMocker mocker = this.createListenerMocker(this.indexBuilder, tempClassInfo);
        mocker.parser(listener.getPostLoad());
        mocker.parser(listener.getPostPersist());
        mocker.parser(listener.getPostRemove());
        mocker.parser(listener.getPostUpdate());
        mocker.parser(listener.getPrePersist());
        mocker.parser(listener.getPreRemove());
        mocker.parser(listener.getPreUpdate());
        this.indexBuilder.finishEntityObject(tempClassInfo.name(), null);
    }

    protected ListenerMocker createListenerMocker(IndexBuilder indexBuilder, ClassInfo classInfo) {
        return new ListenerMocker(indexBuilder, classInfo);
    }

    AnnotationInstance parser(XMLPrePersist callback) {
        if (callback == null) {
            return null;
        }
        return this.create(PRE_PERSIST, this.getListenerTarget(callback.getMethodName()));
    }

    AnnotationInstance parser(XMLPreRemove callback) {
        if (callback == null) {
            return null;
        }
        return this.create(PRE_REMOVE, this.getListenerTarget(callback.getMethodName()));
    }

    AnnotationInstance parser(XMLPreUpdate callback) {
        if (callback == null) {
            return null;
        }
        return this.create(PRE_UPDATE, this.getListenerTarget(callback.getMethodName()));
    }

    AnnotationInstance parser(XMLPostPersist callback) {
        if (callback == null) {
            return null;
        }
        return this.create(POST_PERSIST, this.getListenerTarget(callback.getMethodName()));
    }

    AnnotationInstance parser(XMLPostUpdate callback) {
        if (callback == null) {
            return null;
        }
        return this.create(POST_UPDATE, this.getListenerTarget(callback.getMethodName()));
    }

    AnnotationInstance parser(XMLPostRemove callback) {
        if (callback == null) {
            return null;
        }
        return this.create(POST_REMOVE, this.getListenerTarget(callback.getMethodName()));
    }

    AnnotationInstance parser(XMLPostLoad callback) {
        if (callback == null) {
            return null;
        }
        return this.create(POST_LOAD, this.getListenerTarget(callback.getMethodName()));
    }

    private AnnotationTarget getListenerTarget(String methodName) {
        return MockHelper.getTarget(this.indexBuilder.getServiceRegistry(), this.classInfo, methodName, MockHelper.TargetType.METHOD);
    }

    @Override
    protected AnnotationInstance push(AnnotationInstance annotationInstance) {
        if (annotationInstance != null && annotationInstance.target() != null) {
            this.indexBuilder.addAnnotationInstance(this.classInfo.name(), annotationInstance);
        }
        return annotationInstance;
    }
}

