/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.relational.state.SimpleValueRelationalState;
import org.hibernate.metamodel.relational.state.TupleRelationalState;
import org.hibernate.metamodel.source.hbm.state.relational.HbmColumnRelationalState;
import org.hibernate.metamodel.source.hbm.state.relational.HbmDerivedValueRelationalState;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLColumnElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLManyToOneElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLPropertyElement;
import org.hibernate.metamodel.source.spi.BindingContext;

public class HbmSimpleValueRelationalStateContainer
implements TupleRelationalState {
    private final BindingContext bindingContext;
    private final Set<String> propertyUniqueKeys;
    private final Set<String> propertyIndexes;
    private final List<SimpleValueRelationalState> simpleValueStates;
    private final HibernateTypeDescriptor hibernateTypeDescriptor = new HibernateTypeDescriptor();

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public NamingStrategy getNamingStrategy() {
        return this.getBindingContext().getNamingStrategy();
    }

    public HbmSimpleValueRelationalStateContainer(BindingContext bindingContext, boolean autoColumnCreation, XMLHibernateMapping.XMLClass.XMLId id) {
        this(bindingContext, id.getColumn());
        if (this.simpleValueStates.isEmpty()) {
            if (id.getColumn() == null && !autoColumnCreation) {
                throw new MappingException("No columns to map and auto column creation is disabled.");
            }
            this.simpleValueStates.add(new HbmColumnRelationalState(id, this));
        } else if (id.getColumn() != null) {
            throw new MappingException("column attribute may not be used together with <column> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName(id.getTypeAttribute());
    }

    public HbmSimpleValueRelationalStateContainer(BindingContext bindingContext, boolean autoColumnCreation, XMLHibernateMapping.XMLClass.XMLDiscriminator discriminator) {
        this(bindingContext, discriminator.getFormula(), discriminator.getColumn());
        if (this.simpleValueStates.isEmpty()) {
            if (discriminator.getColumn() == null && discriminator.getFormula() == null && !autoColumnCreation) {
                throw new MappingException("No column or formula to map and auto column creation is disabled.");
            }
            this.simpleValueStates.add(new HbmColumnRelationalState(discriminator, this));
        } else if (discriminator.getColumn() != null || discriminator.getFormula() != null) {
            throw new MappingException("column/formula attribute may not be used together with <column>/<formula> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName(discriminator.getType() == null ? "string" : discriminator.getType());
    }

    public HbmSimpleValueRelationalStateContainer(BindingContext bindingContext, boolean autoColumnCreation, XMLHibernateMapping.XMLClass.XMLVersion version) {
        this(bindingContext, version.getColumn());
        if (this.simpleValueStates.isEmpty()) {
            if (version.getColumn() == null && !autoColumnCreation) {
                throw new MappingException("No column or formula to map and auto column creation is disabled.");
            }
            this.simpleValueStates.add(new HbmColumnRelationalState(version, this));
        } else if (version.getColumn() != null) {
            throw new MappingException("column attribute may not be used together with <column> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName(version.getType() == null ? "integer" : version.getType());
    }

    public HbmSimpleValueRelationalStateContainer(BindingContext bindingContext, boolean autoColumnCreation, XMLHibernateMapping.XMLClass.XMLTimestamp timestamp) {
        this(bindingContext, null);
        if (this.simpleValueStates.isEmpty()) {
            if (timestamp.getColumn() == null && !autoColumnCreation) {
                throw new MappingException("No columns to map and auto column creation is disabled.");
            }
            this.simpleValueStates.add(new HbmColumnRelationalState(timestamp, this));
        } else if (timestamp.getColumn() != null) {
            throw new MappingException("column attribute may not be used together with <column> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName("db".equals(timestamp.getSource()) ? "dbtimestamp" : "timestamp");
    }

    public HbmSimpleValueRelationalStateContainer(BindingContext bindingContext, boolean autoColumnCreation, XMLPropertyElement property) {
        this(bindingContext, property.getColumnOrFormula());
        if (this.simpleValueStates.isEmpty()) {
            if (property.getColumn() == null && property.getFormula() == null && !autoColumnCreation) {
                throw new MappingException("No column or formula to map and auto column creation is disabled.");
            }
            this.simpleValueStates.add(new HbmColumnRelationalState(property, this));
        } else if (property.getColumn() != null || property.getFormula() != null) {
            throw new MappingException("column/formula attribute may not be used together with <column>/<formula> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName(property.getTypeAttribute());
    }

    public HbmSimpleValueRelationalStateContainer(BindingContext bindingContext, boolean autoColumnCreation, XMLManyToOneElement manyToOne) {
        this(bindingContext, manyToOne.getColumnOrFormula());
        if (this.simpleValueStates.isEmpty()) {
            if (manyToOne.getColumn() == null && manyToOne.getFormula() == null && !autoColumnCreation) {
                throw new MappingException("No column or formula to map and auto column creation is disabled.");
            }
            this.simpleValueStates.add(new HbmColumnRelationalState(manyToOne, this));
        } else if (manyToOne.getColumn() != null || manyToOne.getFormula() != null) {
            throw new MappingException("column/formula attribute may not be used together with <column>/<formula> subelement");
        }
    }

    private HbmSimpleValueRelationalStateContainer(BindingContext bindingContext, String formulaElement, XMLColumnElement columnElement) {
        this(bindingContext, formulaElement != null ? Collections.singletonList(formulaElement) : (columnElement != null ? Collections.singletonList(columnElement) : Collections.emptyList()));
    }

    private HbmSimpleValueRelationalStateContainer(BindingContext bindingContext, List mappedColumnsOrFormulas) {
        this.bindingContext = bindingContext;
        this.propertyUniqueKeys = Collections.emptySet();
        this.propertyIndexes = Collections.emptySet();
        this.simpleValueStates = new ArrayList<SimpleValueRelationalState>(mappedColumnsOrFormulas == null || mappedColumnsOrFormulas.isEmpty() ? 1 : mappedColumnsOrFormulas.size());
        if (mappedColumnsOrFormulas != null && !mappedColumnsOrFormulas.isEmpty()) {
            for (Object mappedColumnOrFormula : mappedColumnsOrFormulas) {
                this.simpleValueStates.add(HbmSimpleValueRelationalStateContainer.createColumnOrFormulaRelationalState(this, mappedColumnOrFormula));
            }
        }
    }

    private static SimpleValueRelationalState createColumnOrFormulaRelationalState(HbmSimpleValueRelationalStateContainer container, Object columnOrFormula) {
        if (XMLColumnElement.class.isInstance(columnOrFormula)) {
            return new HbmColumnRelationalState((XMLColumnElement)XMLColumnElement.class.cast(columnOrFormula), container);
        }
        if (String.class.isInstance(columnOrFormula)) {
            return new HbmDerivedValueRelationalState((String)String.class.cast(columnOrFormula));
        }
        throw new MappingException("unknown type of column or formula: " + columnOrFormula.getClass().getName());
    }

    @Override
    public List<SimpleValueRelationalState> getRelationalStates() {
        return this.simpleValueStates;
    }

    Set<String> getPropertyUniqueKeys() {
        return this.propertyUniqueKeys;
    }

    Set<String> getPropertyIndexes() {
        return this.propertyIndexes;
    }
}

