/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.MappingException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;

public class MappingHelper {
    private MappingHelper() {
    }

    public static String getStringValue(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static int getIntValue(String value, int defaultValue) {
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public static boolean getBooleanValue(String value, boolean defaultValue) {
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    public static boolean getBooleanValue(Boolean value, boolean defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Set<String> getStringValueTokens(String str, String delimiters) {
        if (str == null) {
            return Collections.emptySet();
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delimiters);
        HashSet<String> tokens = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    public static Class classForName(String className, ServiceRegistry serviceRegistry) {
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        try {
            return classLoaderService.classForName(className);
        }
        catch (ClassLoadingException e) {
            throw new MappingException("Could not find class: " + className);
        }
    }
}

