/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import java.util.Map;
import org.hibernate.persister.internal.StandardPersisterClassResolver;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class PersisterClassResolverInitiator
implements BasicServiceInitiator<PersisterClassResolver> {
    public static final PersisterClassResolverInitiator INSTANCE = new PersisterClassResolverInitiator();
    public static final String IMPL_NAME = "hibernate.persister.resolver";

    @Override
    public Class<PersisterClassResolver> getServiceInitiated() {
        return PersisterClassResolver.class;
    }

    @Override
    public PersisterClassResolver initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Object customImpl = configurationValues.get(IMPL_NAME);
        if (customImpl == null) {
            return new StandardPersisterClassResolver();
        }
        if (PersisterClassResolver.class.isInstance(customImpl)) {
            return (PersisterClassResolver)customImpl;
        }
        Class customImplClass = Class.class.isInstance(customImpl) ? (Class)customImpl : registry.getService(ClassLoaderService.class).classForName(customImpl.toString());
        try {
            return (PersisterClassResolver)customImplClass.newInstance();
        }
        catch (Exception e) {
            throw new ServiceException("Could not initialize custom PersisterClassResolver impl [" + customImplClass.getName() + "]", e);
        }
    }
}

