/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.UnknownServiceException;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.internal.ServiceDependencyException;
import org.hibernate.service.jmx.spi.JmxService;
import org.hibernate.service.spi.InjectService;
import org.hibernate.service.spi.Manageable;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

public abstract class AbstractServiceRegistryImpl
implements ServiceRegistryImplementor,
ServiceBinding.OwningRegistry {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractServiceRegistryImpl.class.getName());
    private final ServiceRegistryImplementor parent;
    private ConcurrentHashMap<Class, ServiceBinding> serviceBindingMap;
    private List<Service> serviceList = new ArrayList<Service>();

    protected AbstractServiceRegistryImpl() {
        this(null);
    }

    protected AbstractServiceRegistryImpl(ServiceRegistryImplementor parent) {
        this.parent = parent;
        this.serviceBindingMap = CollectionHelper.concurrentMap(20);
        this.serviceList = CollectionHelper.arrayList(20);
    }

    protected <R extends Service> void createServiceBinding(ServiceInitiator<R> initiator) {
        this.serviceBindingMap.put(initiator.getServiceInitiated(), new ServiceBinding<R>(this, initiator));
    }

    protected <R extends Service> void createServiceBinding(ProvidedService<R> providedService) {
        ServiceBinding<Object> binding = this.locateServiceBinding(providedService.getServiceRole(), false);
        if (binding == null) {
            binding = new ServiceBinding<Service>(this, providedService.getServiceRole(), (Service)providedService.getService());
            this.serviceBindingMap.put(providedService.getServiceRole(), binding);
        }
        this.registerService(binding, (Service)providedService.getService());
    }

    @Override
    public ServiceRegistry getParentServiceRegistry() {
        return this.parent;
    }

    @Override
    public <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> serviceRole) {
        return this.locateServiceBinding(serviceRole, true);
    }

    protected <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> serviceRole, boolean checkParent) {
        ServiceBinding<R> serviceBinding = this.serviceBindingMap.get(serviceRole);
        if (serviceBinding == null && checkParent && this.parent != null) {
            serviceBinding = this.parent.locateServiceBinding(serviceRole);
        }
        return serviceBinding;
    }

    @Override
    public <R extends Service> R getService(Class<R> serviceRole) {
        ServiceBinding<R> serviceBinding = this.locateServiceBinding(serviceRole);
        if (serviceBinding == null) {
            throw new UnknownServiceException(serviceRole);
        }
        R service = serviceBinding.getService();
        if (service == null) {
            service = this.initializeService(serviceBinding);
        }
        return service;
    }

    protected <R extends Service> void registerService(ServiceBinding<R> serviceBinding, R service) {
        R priorServiceInstance = serviceBinding.getService();
        serviceBinding.setService(service);
        if (priorServiceInstance != null) {
            this.serviceList.remove(priorServiceInstance);
        }
        this.serviceList.add(service);
    }

    private <R extends Service> R initializeService(ServiceBinding<R> serviceBinding) {
        LOG.trace("Initializing service [role=" + serviceBinding.getServiceRole().getName() + "]");
        R service = this.createService(serviceBinding);
        if (service == null) {
            return null;
        }
        this.configureService((Service)service);
        this.startService(serviceBinding);
        return service;
    }

    protected <R extends Service> R createService(ServiceBinding<R> serviceBinding) {
        ServiceInitiator<R> serviceInitiator = serviceBinding.getServiceInitiator();
        if (serviceInitiator == null) {
            throw new UnknownServiceException(serviceBinding.getServiceRole());
        }
        try {
            R service = serviceBinding.getServiceRegistry().initiateService(serviceInitiator);
            this.registerService(serviceBinding, service);
            return service;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to create requested service [" + serviceBinding.getServiceRole().getName() + "]", e);
        }
    }

    protected abstract <T extends Service> void configureService(T var1);

    protected <T extends Service> void applyInjections(T service) {
        try {
            for (Method method : service.getClass().getMethods()) {
                InjectService injectService = method.getAnnotation(InjectService.class);
                if (injectService == null) continue;
                this.applyInjection(service, method, injectService);
            }
        }
        catch (NullPointerException e) {
            LOG.error("NPE injecting service deps : " + service.getClass().getName());
        }
    }

    private <T extends Service> void applyInjection(T service, Method injectionMethod, InjectService injectService) {
        Object dependantService;
        if (injectionMethod.getParameterTypes() == null || injectionMethod.getParameterTypes().length != 1) {
            throw new ServiceDependencyException("Encountered @InjectService on method with unexpected number of parameters");
        }
        Class<?> dependentServiceRole = injectService.serviceRole();
        if (dependentServiceRole == null || dependentServiceRole.equals(Void.class)) {
            dependentServiceRole = injectionMethod.getParameterTypes()[0];
        }
        if ((dependantService = this.getService(dependentServiceRole)) == null) {
            if (injectService.required()) {
                throw new ServiceDependencyException("Dependency [" + dependentServiceRole + "] declared by service [" + service + "] not found");
            }
        } else {
            try {
                injectionMethod.invoke(service, dependantService);
            }
            catch (Exception e) {
                throw new ServiceDependencyException("Cannot inject dependency service", e);
            }
        }
    }

    protected <R extends Service> void startService(ServiceBinding<R> serviceBinding) {
        if (Startable.class.isInstance(serviceBinding.getService())) {
            ((Startable)serviceBinding.getService()).start();
        }
        if (Manageable.class.isInstance(serviceBinding.getService())) {
            this.getService(JmxService.class).registerService((Manageable)serviceBinding.getService(), serviceBinding.getServiceRole());
        }
    }

    @Override
    public void destroy() {
        ListIterator<Service> serviceIterator = this.serviceList.listIterator(this.serviceList.size());
        while (serviceIterator.hasPrevious()) {
            Service service = serviceIterator.previous();
            if (!Stoppable.class.isInstance(service)) continue;
            try {
                ((Stoppable)((Object)service)).stop();
            }
            catch (Exception e) {
                LOG.unableToStopService(service.getClass(), e.toString());
            }
        }
        this.serviceList.clear();
        this.serviceList = null;
        this.serviceBindingMap.clear();
        this.serviceBindingMap = null;
    }
}

