/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.spi;

import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceInitiator;
import org.jboss.logging.Logger;

public final class ServiceBinding<R extends Service> {
    private static final Logger log = Logger.getLogger(ServiceBinding.class);
    private final OwningRegistry serviceRegistry;
    private final Class<R> serviceRole;
    private final ServiceInitiator<R> serviceInitiator;
    private R service;

    public ServiceBinding(OwningRegistry serviceRegistry, Class<R> serviceRole, R service) {
        this.serviceRegistry = serviceRegistry;
        this.serviceRole = serviceRole;
        this.serviceInitiator = null;
        this.service = service;
    }

    public ServiceBinding(OwningRegistry serviceRegistry, ServiceInitiator<R> serviceInitiator) {
        this.serviceRegistry = serviceRegistry;
        this.serviceRole = serviceInitiator.getServiceInitiated();
        this.serviceInitiator = serviceInitiator;
    }

    public OwningRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public Class<R> getServiceRole() {
        return this.serviceRole;
    }

    public ServiceInitiator<R> getServiceInitiator() {
        return this.serviceInitiator;
    }

    public R getService() {
        return this.service;
    }

    public void setService(R service) {
        if (this.service != null && log.isDebugEnabled()) {
            log.debug((Object)("Overriding existing service binding [" + this.serviceRole.getName() + "]"));
        }
        this.service = service;
    }

    public static interface OwningRegistry {
        public <R extends Service> R initiateService(ServiceInitiator<R> var1);
    }
}

