/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;
import org.jboss.logging.Logger;

public class EnumType
implements EnhancedUserType,
ParameterizedType,
Serializable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EnumType.class.getName());
    public static final String ENUM = "enumClass";
    public static final String SCHEMA = "schema";
    public static final String CATALOG = "catalog";
    public static final String TABLE = "table";
    public static final String COLUMN = "column";
    public static final String TYPE = "type";
    private Class<? extends Enum> enumClass;
    private transient Object[] enumValues;
    private int sqlType = 4;

    @Override
    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    @Override
    public Class<? extends Enum> returnedClass() {
        return this.enumClass;
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    @Override
    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object object = rs.getObject(names[0]);
        if (rs.wasNull()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Returning null as column " + names[0]);
            }
            return null;
        }
        if (object instanceof Number) {
            this.initEnumValues();
            int ordinal = ((Number)object).intValue();
            if (ordinal < 0 || ordinal >= this.enumValues.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Returning '" + ordinal + "' as column " + names[0]);
            }
            return this.enumValues[ordinal];
        }
        String name = (String)object;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Returning '" + name + "' as column " + names[0]);
        }
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + name, iae);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Binding null to parameter: " + index);
            }
            st.setNull(index, this.sqlType);
        } else {
            boolean isOrdinal = this.isOrdinal(this.sqlType);
            if (isOrdinal) {
                int ordinal = ((Enum)value).ordinal();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Binding '" + ordinal + "' to parameter: " + index);
                }
                st.setObject(index, (Object)ordinal, this.sqlType);
            } else {
                String enumString = ((Enum)value).name();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Binding '" + enumString + "' to parameter: " + index);
                }
                st.setObject(index, (Object)enumString, this.sqlType);
            }
        }
    }

    private boolean isOrdinal(int paramType) {
        switch (paramType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                return false;
            }
        }
        throw new HibernateException("Unable to persist an Enum in a column of SQL Type: " + paramType);
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    @Override
    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    @Override
    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    @Override
    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty(ENUM);
        try {
            this.enumClass = ReflectHelper.classForName(enumClassName, this.getClass()).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException exception) {
            throw new HibernateException("Enum class not found", exception);
        }
        String type = parameters.getProperty(TYPE);
        if (type != null) {
            this.sqlType = Integer.decode(type);
        }
    }

    private void initEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = this.enumClass.getEnumConstants();
            if (this.enumValues == null) {
                throw new NullPointerException("Failed to init enumValues");
            }
        }
    }

    @Override
    public String objectToSQLString(Object value) {
        boolean isOrdinal = this.isOrdinal(this.sqlType);
        if (isOrdinal) {
            int ordinal = ((Enum)value).ordinal();
            return Integer.toString(ordinal);
        }
        return '\'' + ((Enum)value).name() + '\'';
    }

    @Override
    public String toXMLString(Object value) {
        boolean isOrdinal = this.isOrdinal(this.sqlType);
        if (isOrdinal) {
            int ordinal = ((Enum)value).ordinal();
            return Integer.toString(ordinal);
        }
        return ((Enum)value).name();
    }

    @Override
    public Object fromXMLString(String xmlValue) {
        try {
            int ordinal = Integer.parseInt(xmlValue);
            this.initEnumValues();
            if (ordinal < 0 || ordinal >= this.enumValues.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            return this.enumValues[ordinal];
        }
        catch (NumberFormatException e) {
            try {
                return Enum.valueOf(this.enumClass, xmlValue);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + xmlValue, iae);
            }
        }
    }
}

