/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.ArrayKey;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.EjbJarConfiguration;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.msc.service.ServiceName;

public class EJBComponentCreateService
extends BasicComponentCreateService {
    private final ConcurrentMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>> txAttrs;
    private final TransactionManagementType transactionManagementType;
    private final EjbJarConfiguration ejbJarConfiguration;
    private final Map<String, ServiceName> viewServices;
    private final EJBSecurityMetaData securityMetaData;

    public EJBComponentCreateService(ComponentConfiguration componentConfiguration, EjbJarConfiguration ejbJarConfiguration) {
        super(componentConfiguration);
        this.ejbJarConfiguration = ejbJarConfiguration;
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        this.transactionManagementType = ejbComponentDescription.getTransactionManagementType();
        this.txAttrs = this.transactionManagementType.equals((Object)TransactionManagementType.CONTAINER) ? new ConcurrentHashMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>>() : null;
        this.securityMetaData = new EJBSecurityMetaData(componentConfiguration);
        List views = componentConfiguration.getViews();
        if (views != null) {
            for (ViewConfiguration view : views) {
                EJBViewConfiguration ejbView = (EJBViewConfiguration)view;
                MethodIntf viewType = ejbView.getMethodIntf();
                for (Method method : view.getProxyFactory().getCachedMethods()) {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    Method componentMethod = EJBComponentCreateService.getComponentMethod(componentConfiguration, method.getName(), method.getParameterTypes());
                    this.processTxAttr(ejbComponentDescription, viewType, componentMethod);
                }
            }
        }
        for (Method method : componentConfiguration.getComponentClass().getMethods()) {
            this.processTxAttr(ejbComponentDescription, MethodIntf.BEAN, method);
        }
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        for (ViewDescription view : componentConfiguration.getComponentDescription().getViews()) {
            viewServices.put(view.getViewClassName(), view.getServiceName());
        }
        this.viewServices = viewServices;
    }

    private static Method getComponentMethod(ComponentConfiguration componentConfiguration, String name, Class<?>[] parameterTypes) {
        try {
            return componentConfiguration.getComponentClass().getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    ConcurrentMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>> getTxAttrs() {
        return this.txAttrs;
    }

    TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    EjbJarConfiguration getEjbJarConfiguration() {
        return this.ejbJarConfiguration;
    }

    private void processTxAttr(EJBComponentDescription ejbComponentDescription, MethodIntf methodIntf, Method method) {
        ConcurrentHashMap<ArrayKey, TransactionAttributeType> perMethod;
        if (this.getTransactionManagementType().equals((Object)TransactionManagementType.BEAN)) {
            return;
        }
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        TransactionAttributeType txAttr = ejbComponentDescription.getTransactionAttribute(methodIntf, className, methodName, EJBComponentCreateService.toString(method.getParameterTypes()));
        ConcurrentHashMap<String, ConcurrentHashMap<ArrayKey, TransactionAttributeType>> perMethodIntf = (ConcurrentHashMap<String, ConcurrentHashMap<ArrayKey, TransactionAttributeType>>)this.txAttrs.get((Object)methodIntf);
        if (perMethodIntf == null) {
            perMethodIntf = new ConcurrentHashMap<String, ConcurrentHashMap<ArrayKey, TransactionAttributeType>>();
            this.txAttrs.put(methodIntf, perMethodIntf);
        }
        if ((perMethod = (ConcurrentHashMap<ArrayKey, TransactionAttributeType>)perMethodIntf.get(methodName)) == null) {
            perMethod = new ConcurrentHashMap<ArrayKey, TransactionAttributeType>();
            perMethodIntf.put(methodName, perMethod);
        }
        perMethod.put(new ArrayKey(method.getParameterTypes()), txAttr);
    }

    private static String[] toString(Class<?>[] a) {
        String[] result = new String[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i].getName();
        }
        return result;
    }

    public Map<String, ServiceName> getViewServices() {
        return this.viewServices;
    }

    public EJBSecurityMetaData getSecurityMetaData() {
        return this.securityMetaData;
    }
}

