/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class SecurityDomainProcessor
extends AbstractAnnotationEJBProcessor<EJBComponentDescription> {
    private static final Logger logger = Logger.getLogger(SecurityDomainProcessor.class);
    private static final DotName SECURITY_DOMAIN_DOT_NAME = DotName.createSimple((String)"org.jboss.ejb3.annotation.SecurityDomain");

    @Override
    protected Class<EJBComponentDescription> getComponentDescriptionType() {
        return EJBComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex index, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map annotationsOnBean = beanClass.annotations();
        if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
            return;
        }
        List securityDomainAnnotations = (List)annotationsOnBean.get(SECURITY_DOMAIN_DOT_NAME);
        if (securityDomainAnnotations == null || securityDomainAnnotations.isEmpty()) {
            return;
        }
        AnnotationInstance securityDomainAnnotation = (AnnotationInstance)securityDomainAnnotations.get(0);
        String securityDomain = securityDomainAnnotation.value().asString();
        logger.debug((Object)("EJB " + componentDescription.getEJBName() + " is annotated with @SecurityDomain named: " + securityDomain));
        if (securityDomain.trim().isEmpty()) {
            throw new DeploymentUnitProcessingException("SecurityDomain value on bean class: " + componentDescription.getEJBClassName() + " cannot be an empty string");
        }
        componentDescription.setSecurityDomain(securityDomain);
    }
}

