/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.jaxb.internal;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.switchyard.Message;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.config.model.Scannable;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.BaseTransformer;

@Scannable(value=false)
public class JAXBMarshalTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private String _contextPath;
    private JAXBContext _jaxbContext;

    public JAXBMarshalTransformer(QName from, QName to, String contextPath) throws SwitchYardException {
        super(from, to);
        this._contextPath = contextPath;
        try {
            this._jaxbContext = JAXBContext.newInstance((String)contextPath);
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to create JAXBContext for contextPath '" + this._contextPath + "'.", (Throwable)e);
        }
    }

    public Message transform(Message message) {
        Marshaller marshaller;
        try {
            marshaller = this._jaxbContext.createMarshaller();
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to create Marshaller for contextPath '" + this._contextPath + "'.", (Throwable)e);
        }
        try {
            StringWriter resultWriter = new StringWriter();
            Object javaObject = message.getContent();
            JAXBElement jaxbElement = new JAXBElement(this.getTo(), QNameUtil.toJavaMessageType((QName)this.getFrom()), javaObject);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)jaxbElement, (Writer)resultWriter);
            message.setContent((Object)resultWriter.toString());
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to unmarshall for contextPath '" + this._contextPath + "'.", (Throwable)e);
        }
        return message;
    }
}

