/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.json.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.BaseTransformer;

public class Java2JSONTransformer<F, T>
extends BaseTransformer<Object, String> {
    private ObjectMapper _mapper;
    private Class _clazz;

    public Java2JSONTransformer(QName from, QName to, ObjectMapper mapper, Class clazz) {
        super(from, to);
        this._mapper = mapper;
        this._clazz = clazz;
    }

    public String transform(Object from) {
        try {
            StringWriter writer = new StringWriter();
            if (this._clazz.isInstance(from)) {
                this._mapper.writeValue((Writer)writer, from);
                return writer.toString();
            }
            throw new SwitchYardException("The object to transform is of wrong instance type " + from.getClass());
        }
        catch (JsonProcessingException e) {
            throw new SwitchYardException("Unexpected JSON processing exception, check your transformer configuration", (Throwable)e);
        }
        catch (IOException e) {
            throw new SwitchYardException("Unexpected I/O exception, check your transformer configuration", (Throwable)e);
        }
    }
}

