/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache;

import java.util.Map;
import org.jboss.ejb3.cache.CacheFactoryNotRegisteredException;
import org.jboss.ejb3.cache.Ejb3CacheFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheFactoryRegistry {
    private Map<String, Class<? extends Ejb3CacheFactory>> factories;

    public Map<String, Class<? extends Ejb3CacheFactory>> getFactories() {
        return this.factories;
    }

    public void setFactories(Map<String, Class<? extends Ejb3CacheFactory>> factories) {
        this.factories = factories;
    }

    public Ejb3CacheFactory getCacheFactory(String name) throws CacheFactoryNotRegisteredException {
        Class<? extends Ejb3CacheFactory> cacheFactory = this.factories.get(name);
        if (cacheFactory == null) {
            throw new CacheFactoryNotRegisteredException("Cache Factory with name " + name + " is not registered.");
        }
        try {
            return cacheFactory.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error in instanciating cache factory " + cacheFactory.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

