/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.dmr.ModelNode;

public class ServerDescriptions {
    private static final String RESOURCE_NAME = ServerDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private ServerDescriptions() {
    }

    public static final ModelNode getRemoveDeploymentOperation(Locale locale) {
        ResourceBundle bundle = ServerDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle.getString("deployment.remove"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getServerReloadOperation(Locale locale) {
        ResourceBundle bundle = ServerDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("reload");
        root.get("description").set(bundle.getString("reload"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getSystemPropertyDescription(Locale locale) {
        ResourceBundle bundle = ServerDescriptions.getResourceBundle(locale);
        return CommonDescriptions.getSystemPropertyDescription((Locale)locale, (String)bundle.getString("server.system-property"), (boolean)false);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

