/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ManagementDescription;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.server.Services;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class NativeManagementAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final NativeManagementAddHandler INSTANCE = new NativeManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("interface").set(operation.require("interface").asString());
        model.get("port").set(operation.require("port").asInt());
        if (operation.hasDefined("security-realm")) {
            model.get("security-realm").set(operation.require("security-realm").asString());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        String interfaceName = operation.require("interface").asString();
        int port = operation.require("port").asInt();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName interfaceSvcName = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName});
        ServiceName realmSvcName = null;
        if (operation.hasDefined("security-realm")) {
            realmSvcName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{operation.require("security-realm").asString()});
        }
        RemotingServices.installStandaloneConnectorServices((ServiceTarget)serviceTarget, (ServiceName)interfaceSvcName, (int)port, realmSvcName, (ServiceVerificationHandler)verificationHandler, newControllers);
        RemotingServices.installChannelServices((ServiceTarget)serviceTarget, (AbstractModelControllerOperationHandlerFactoryService)new ModelControllerClientOperationHandlerFactoryService(), (ServiceName)Services.JBOSS_SERVER_CONTROLLER, (String)"management", (ServiceVerificationHandler)verificationHandler, newControllers);
    }

    public ModelNode getModelDescription(Locale locale) {
        return ManagementDescription.getAddNativeManagementDescription((Locale)locale);
    }
}

