/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.classfilewriter.annotations.AnnotationAnnotationValue;
import org.jboss.classfilewriter.annotations.AnnotationValue;
import org.jboss.classfilewriter.annotations.ArrayAnnotationValue;
import org.jboss.classfilewriter.annotations.BooleanAnnotationValue;
import org.jboss.classfilewriter.annotations.ByteAnnotationValue;
import org.jboss.classfilewriter.annotations.CharAnnotationValue;
import org.jboss.classfilewriter.annotations.ClassAnnotation;
import org.jboss.classfilewriter.annotations.ClassAnnotationValue;
import org.jboss.classfilewriter.annotations.DoubleAnnotationValue;
import org.jboss.classfilewriter.annotations.EnumAnnotationValue;
import org.jboss.classfilewriter.annotations.FloatAnnotationValue;
import org.jboss.classfilewriter.annotations.IntAnnotationValue;
import org.jboss.classfilewriter.annotations.LongAnnotationValue;
import org.jboss.classfilewriter.annotations.ShortAnnotationValue;
import org.jboss.classfilewriter.annotations.StringAnnotationValue;
import org.jboss.classfilewriter.constpool.ConstPool;

public class AnnotationBuilder {
    public static ClassAnnotation createAnnotation(ConstPool constPool, Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        ArrayList<AnnotationValue> values = new ArrayList<AnnotationValue>();
        try {
            for (Method m : annotationType.getDeclaredMethods()) {
                Object value = m.invoke((Object)annotation, new Object[0]);
                values.add(AnnotationBuilder.createValue(constPool, m.getName(), value));
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return new ClassAnnotation(constPool, annotationType.getName(), values);
    }

    public static AnnotationValue createValue(ConstPool constPool, String name, Object value) {
        Class<?> type = value.getClass();
        if (type == String.class) {
            return new StringAnnotationValue(constPool, name, (String)value);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new IntAnnotationValue(constPool, name, (Integer)value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return new ShortAnnotationValue(constPool, name, (Short)value);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return new ByteAnnotationValue(constPool, name, (Byte)value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return new BooleanAnnotationValue(constPool, name, (Boolean)value);
        }
        if (type == Character.TYPE || type == Character.class) {
            return new CharAnnotationValue(constPool, name, ((Character)value).charValue());
        }
        if (type == Long.TYPE || type == Long.class) {
            return new LongAnnotationValue(constPool, name, (Long)value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return new FloatAnnotationValue(constPool, name, ((Float)value).floatValue());
        }
        if (type == Double.TYPE || type == Double.class) {
            return new DoubleAnnotationValue(constPool, name, (Double)value);
        }
        if (type == Class.class) {
            return new ClassAnnotationValue(constPool, name, (Class)value);
        }
        if (type.isEnum() || type.getEnclosingClass() != null && type.getEnclosingClass().isEnum()) {
            return new EnumAnnotationValue(constPool, name, (Enum)value);
        }
        if (value instanceof Annotation) {
            return new AnnotationAnnotationValue(constPool, name, AnnotationBuilder.createAnnotation(constPool, (Annotation)value));
        }
        if (type.isArray()) {
            int length = Array.getLength(value);
            ArrayList<AnnotationValue> values = new ArrayList<AnnotationValue>();
            for (int i = 0; i < length; ++i) {
                values.add(AnnotationBuilder.createValue(constPool, null, Array.get(value, i)));
            }
            return new ArrayAnnotationValue(constPool, name, values);
        }
        throw new RuntimeException("Invalid type for annotation value. Type: " + type + " Value: " + value);
    }

    private AnnotationBuilder() {
    }
}

