/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    ACCEPTORS("acceptors"),
    ADDRESS("address"),
    ADDRESS_SETTINGS("address-settings"),
    ASYNC_CONNECTION_EXECUTION_ENABLED("async-connection-execution-enabled"),
    BACKUP("backup"),
    BINDINGS_DIRECTORY("bindings-directory"),
    BROADCAST_PERIOD("broadcast-period"),
    CLUSTER_PASSWORD("cluster-password"),
    CLUSTER_USER("cluster-user"),
    CLUSTERED("clustered"),
    CONNECTION_TTL_OVERRIDE("connection-ttl-override"),
    CONNECTOR_REF("connector-ref"),
    CORE_QUEUES("core-queues"),
    CREATE_BINDINGS_DIR("create-bindings-dir"),
    CREATE_JOURNAL_DIR("create-journal-dir"),
    DURABLE("durable"),
    FILE_DEPLOYMENT_ENABLED("file-deployment-enabled"),
    GROUP_ADDRESS("group-address"),
    GROUP_PORT("group-port"),
    GROUPING_HANDLER("grouping-handler"),
    ID_CACHE_SIZE("id-cache-size"),
    IN_VM_ACCEPTOR("in-vm-acceptor"),
    IN_VM_CONNECTOR("in-vm-connector"),
    JMX_DOMAIN("jmx-domain"),
    JMX_MANAGEMENT_ENABLED("jmx-management-enabled"),
    JOURNAL_BUFFER_SIZE("journal-buffer-size"),
    JOURNAL_BUFFER_TIMEOUT("journal-buffer-timeout"),
    JOURNAL_COMPACT_MIN_FILES("journal-compact-min-files"),
    JOURNAL_COMPACT_PERCENTAGE("journal-compact-percentage"),
    JOURNAL_DIRECTORY("journal-directory"),
    JOURNAL_FILE_SIZE("journal-file-size"),
    JOURNAL_MAX_IO("journal-max-io"),
    JOURNAL_MIN_FILES("journal-min-files"),
    JOURNAL_SYNC_NON_TRANSACTIONAL("journal-sync-non-transactional"),
    JOURNAL_SYNC_TRANSACTIONAL("journal-sync-transactional"),
    JOURNAL_TYPE("journal-type"),
    LARGE_MESSAGES_DIRECTORY("large-messages-directory"),
    LOCAL_BIND_ADDRESS("local-bind-address"),
    LOCAL_BIND_PORT("local-bind-port"),
    LOG_JOURNAL_WRITE_RATE("log-journal-write-rate"),
    MANAGEMENT_ADDRESS("management-address"),
    MANAGEMENT_NOTIFICATION_ADDRESS("management-notification-address"),
    MEMORY_MEASURE_INTERVAL("memory-measure-interval"),
    MEMORY_WARNING_THRESHOLD("memory-warning-threshold"),
    MESSAGE_COUNTER_ENABLED("message-counter-enabled"),
    MESSAGE_COUNTER_MAX_DAY_HISTORY("message-counter-max-day-history"),
    MESSAGE_COUNTER_SAMPLE_PERIOD("message-counter-sample-period"),
    MESSAGE_EXPIRY_SCAN_PERIOD("message-expiry-scan-period"),
    MESSAGE_EXPIRY_THREAD_PRIORITY("message-expiry-thread-priority"),
    NETTY_ACCEPTOR("netty-acceptor"),
    NETTY_CONNECTOR("netty-connector"),
    PAGING_DIRECTORY("paging-directory"),
    PERF_BLAST_PAGES("perf-blast-pages"),
    PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY("persist-delivery-count-before-delivery"),
    PERSIST_ID_CACHE("persist-id-cache"),
    PERSISTENCE_ENABLED("persistence-enabled"),
    QUEUE("queue"),
    REFRESH_TIMEOUT("refresh-timeout"),
    REMOTING_INTERCEPTORS("remoting-interceptors"),
    RUN_SYNC_SPEED_TEST("run-sync-speed-test"),
    SECURITY_ENABLED("security-enabled"),
    SECURITY_INVALIDATION_INTERVAL("security-invalidation-interval"),
    SECURITY_SETTINGS("security-settings"),
    SERVER_DUMP_INTERVAL("server-dump-interval"),
    SHARED_STORE("shared-store"),
    SUBSYSTEM("subsystem"),
    TRANSACTION_TIMEOUT("transaction-timeout"),
    TRANSACTION_TIMEOUT_SCAN_PERIOD("transaction-timeout-scan-period"),
    WILD_CARD_ROUTING_ENABLED("wild-card-routing-enabled"),
    ACCEPTOR("acceptor"),
    CONNECTORS("connectors"),
    CONNECTOR("connector"),
    FACTORY_CLASS("factory-class"),
    FILTER("filter"),
    PARAM("param"),
    SECURITY_SETTING("security-setting"),
    PERMISSION_ELEMENT_NAME("permission"),
    ADDRESS_SETTING("address-setting"),
    DEAD_LETTER_ADDRESS_NODE_NAME("dead-letter-address"),
    EXPIRY_ADDRESS_NODE_NAME("expiry-address"),
    REDELIVERY_DELAY_NODE_NAME("redelivery-delay"),
    MAX_DELIVERY_ATTEMPTS("max-delivery-attempts"),
    MAX_SIZE_BYTES_NODE_NAME("max-size-bytes"),
    ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME("address-full-policy"),
    PAGE_SIZE_BYTES_NODE_NAME("page-size-bytes"),
    MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME("message-counter-history-day-limit"),
    LVQ_NODE_NAME("last-value-queue"),
    REDISTRIBUTION_DELAY_NODE_NAME("redistribution-delay"),
    SEND_TO_DLA_ON_NO_ROUTE("send-to-dla-on-no-route"),
    AUTO_GROUP("auto-group"),
    BLOCK_ON_ACK("block-on-acknowledge"),
    BLOCK_ON_DURABLE_SEND("block-on-durable-send"),
    BLOCK_ON_NON_DURABLE_SEND("block-on-non-durable-send"),
    CACHE_LARGE_MESSAGE_CLIENT("cache-large-message-client"),
    CALL_TIMEOUT("call-timeout"),
    CLIENT_FAILURE_CHECK_PERIOD("client-failure-check-period"),
    CLIENT_ID("client-id"),
    CONNECTION_FACTORY("connection-factory"),
    CONNECTION_FACTORIES("jms-connection-factories"),
    CONNECTION_TTL("connection-ttl"),
    CONFIRMATION_WINDOW_SIZE("confirmation-window-size"),
    CONSUMER_MAX_RATE("consumer-max-rate"),
    CONSUMER_WINDOW_SIZE("consumer-window-size"),
    DISCOVERY_INITIAL_WAIT_TIMEOUT("discovery-initial-wait-timeout"),
    DISCOVERY_GROUP_REF("discovery-group-ref"),
    DUPS_OK_BATCH_SIZE("dups-ok-batch-size"),
    ENTRIES("entries"),
    ENTRY("entry"),
    FAILOVER_ON_INITIAL_CONNECTION("failover-on-initial-connection"),
    FAILOVER_ON_SERVER_SHUTDOWN("failover-on-server-shutdown"),
    GROUP_ID("group-id"),
    JMS_DESTINATIONS("jms-destinations"),
    JMS_TOPIC("jms-topic"),
    JMS_QUEUE("jms-queue"),
    LOAD_BALANCING_CLASS_NAME("connection-load-balancing-policy-class-name"),
    MAX_RETRY_INTERVAL("max-retry-interval"),
    MIN_LARGE_MESSAGE_SIZE("min-large-message-size"),
    PRE_ACK("pre-acknowledge"),
    PRODUCER_WINDOW_SIZE("producer-window-size"),
    PRODUCER_MAX_RATE("producer-max-rate"),
    RECONNECT_ATTEMPTS("reconnect-attempts"),
    RETRY_INTERVAL("retry-interval"),
    RETRY_INTERVAL_MULTIPLIER("retry-interval-multiplier"),
    SELECTOR("selector"),
    SCHEDULED_THREAD_POOL_MAX_SIZE("scheduled-thread-pool-max-size"),
    THREAD_POOL_MAX_SIZE("thread-pool-max-size"),
    TRANSACTION_BATH_SIZE("transaction-batch-size"),
    USE_GLOBAL_POOLS("use-global-pools"),
    POOLED_CONNECTION_FACTORY("pooled-connection-factory"),
    TRANSACTION("transaction"),
    MODE("mode"),
    INBOUND_CONFIG("inbound-config"),
    USE_JNDI("use-jndi"),
    JNDI_PARAMS("jndi-params"),
    USE_LOCAL_TX("use-local-tx"),
    SETUP_ATTEMPTS("setup-attempts"),
    SETUP_INTERVAL("setup-interval");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

