/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class MessagingSubsystemDescribeHandler
implements OperationStepHandler {
    static final MessagingSubsystemDescribeHandler INSTANCE = new MessagingSubsystemDescribeHandler();

    MessagingSubsystemDescribeHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode address;
        ModelNode subsystemAdd = new ModelNode();
        ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(rootAddress.toModelNode());
        for (String attribute : MessagingSubsystemProviders.MESSAGING_ROOT_ATTRIBUTES) {
            if (!subModel.hasDefined(attribute)) continue;
            subsystemAdd.get(attribute).set(subModel.get(attribute));
        }
        ModelNode result = context.getResult();
        result.add(subsystemAdd);
        if (subModel.hasDefined("connection-factory")) {
            for (Property property : subModel.get("connection-factory").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("connection-factory", property.getName());
                result.add(ConnectionFactoryAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("queue")) {
            for (Property property : subModel.get("queue").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("queue", property.getName());
                result.add(JMSQueueAdd.getOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("jms-topic")) {
            for (Property property : subModel.get("jms-topic").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("jms-topic", property.getName());
                result.add(JMSTopicAdd.getOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("pooled-connection-factory")) {
            for (Property property : subModel.get("pooled-connection-factory").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("pooled-connection-factory", property.getName());
                result.add(PooledConnectionFactoryAdd.getAddOperation(address, property.getValue()));
            }
        }
        context.completeStep();
    }
}

