/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import java.util.Locale;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.QueueService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class QueueAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static QueueAdd INSTANCE = new QueueAdd();
    private final ParametersValidator validator = new ParametersValidator();

    public static ModelNode getOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("queue-address").set(existing.get("address"));
        if (existing.hasDefined("filter")) {
            op.get("filter").set(existing.get("filter"));
        }
        if (existing.hasDefined("durable")) {
            op.get("durable").set(existing.get("durable"));
        }
        return op;
    }

    private QueueAdd() {
        this.validator.registerValidator("queue-address", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.validator.registerValidator("filter", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.validator.registerValidator("durable", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.validator.validate(operation);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String queueAddress = operation.hasDefined("queue-address") ? operation.get("queue-address").asString() : null;
        String filter = operation.hasDefined("filter") ? operation.get("filter").asString() : null;
        Boolean durable = operation.hasDefined("durable") ? Boolean.valueOf(operation.get("durable").asBoolean()) : null;
        model.get("name").set(name);
        if (queueAddress != null) {
            model.get("address").set(queueAddress);
        }
        if (filter != null) {
            model.get("filter").set(filter);
        }
        if (durable != null) {
            model.get("durable").set(durable.booleanValue());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String queueAddress = operation.hasDefined("queue-address") ? operation.get("queue-address").asString() : null;
        String filter = operation.hasDefined("filter") ? operation.get("filter").asString() : null;
        Boolean durable = operation.hasDefined("durable") ? Boolean.valueOf(operation.get("durable").asBoolean()) : null;
        QueueService service = new QueueService(queueAddress, name, filter, durable != null ? durable : true, false);
        newControllers.add(context.getServiceTarget().addService(MessagingServices.CORE_QUEUE_BASE.append(new String[]{name}), (Service)service).addDependency(MessagingServices.JBOSS_MESSAGING, HornetQServer.class, service.getHornetQService()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getQueueAdd(locale);
    }
}

