/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.io.IOException;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerChain;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.DefaultContext;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.io.Serialization;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.spi.Dispatcher;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.TransformerRegistry;

@Serialization.Strategy(access=Serialization.AccessType.FIELD, coverage=Serialization.CoverageType.EXCLUSIVE, factory=ExchangeImplFactory.class)
public class ExchangeImpl
implements Exchange {
    private static Logger _log = Logger.getLogger(ExchangeImpl.class);
    @Serialization.Include
    private ExchangeContract _contract;
    @Serialization.Include
    private ExchangePhase _phase;
    @Serialization.Include
    private QName _serviceName;
    @Serialization.Include
    private Message _message;
    @Serialization.Include
    private ExchangeState _state = ExchangeState.OK;
    private Dispatcher _dispatch;
    private TransformerRegistry _transformerRegistry;
    private HandlerChain _replyChain;
    @Serialization.Include
    private Context _context;

    private ExchangeImpl() {
    }

    public ExchangeImpl(QName serviceName, ExchangeContract contract, Dispatcher dispatch, TransformerRegistry transformerRegistry) {
        this(serviceName, contract, dispatch, transformerRegistry, null);
    }

    public ExchangeImpl(QName serviceName, ExchangeContract contract, Dispatcher dispatch, TransformerRegistry transformerRegistry, HandlerChain replyChain) {
        if (contract == null) {
            throw new IllegalArgumentException("null 'contract' arg.");
        }
        if (contract.getInvokerInvocationMetaData() == null) {
            throw new IllegalArgumentException("Invalid 'contract' arg.  No invoker invocation metadata defined on the contract instance.");
        }
        if (contract.getServiceOperation() == null) {
            throw new IllegalArgumentException("Invalid 'contract' arg.  No ServiceOperation defined on the contract instance.");
        }
        ExchangePattern exchangePattern = contract.getServiceOperation().getExchangePattern();
        if (replyChain == null && exchangePattern == ExchangePattern.IN_OUT) {
            throw new SwitchYardException("Invalid Exchange construct.  Must supply an reply handler for an IN_OUT Exchange.");
        }
        this._serviceName = serviceName;
        this._contract = contract;
        this._dispatch = dispatch;
        this._transformerRegistry = transformerRegistry;
        this._replyChain = replyChain;
        this._context = new DefaultContext();
    }

    public Context getContext() {
        return this._context;
    }

    public ExchangeContract getContract() {
        return this._contract;
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    public Message getMessage() {
        return this._message;
    }

    public synchronized void send(Message message) {
        this.assertMessageOK(message);
        if (this._phase == null) {
            this._phase = ExchangePhase.IN;
            this.initInTransformSequence();
        } else if (this._phase.equals((Object)ExchangePhase.IN)) {
            this._phase = ExchangePhase.OUT;
            this.initOutTransformSequence();
            this._context.setProperty("org.switchyard.relatesTo", this._context.getProperty("org.switchyard.messageId", Scope.IN).getValue(), Scope.OUT);
        } else {
            throw new IllegalStateException("Send message not allowed for exchange in phase " + this._phase);
        }
        this.sendInternal(message);
    }

    public synchronized void sendFault(Message message) {
        this.assertMessageOK(message);
        if (this._phase == null) {
            throw new IllegalStateException("Send fault no allowed on new exchanges");
        }
        this._phase = ExchangePhase.OUT;
        this._state = ExchangeState.FAULT;
        this.sendInternal(message);
    }

    public ExchangeState getState() {
        return this._state;
    }

    public Dispatcher getDispatcher() {
        return this._dispatch;
    }

    public HandlerChain getReplyChain() {
        return this._replyChain;
    }

    public void setOutputDispatcher(Dispatcher dispatch) {
        this._dispatch = dispatch;
    }

    private void sendInternal(Message message) {
        this._message = message;
        this._context.setProperty("org.switchyard.messageId", (Object)UUID.randomUUID().toString(), Scope.activeScope((Exchange)this));
        if (ExchangeState.FAULT.equals((Object)this._state) && this._replyChain == null) {
            String faultContent;
            try {
                faultContent = (String)this._message.getContent(String.class);
            }
            catch (Exception ex) {
                faultContent = this._message.getContent().toString();
            }
            _log.warn((Object)("Fault generated during exchange without a handler: " + faultContent));
            return;
        }
        this._dispatch.dispatch(this);
    }

    private void assertMessageOK(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("Invalid null 'message' argument in method call.");
        }
        if (this._state == ExchangeState.FAULT) {
            throw new IllegalStateException("Exchange instance is in a FAULT state.");
        }
    }

    public Message createMessage() {
        return new DefaultMessage().setTransformerRegistry(this._transformerRegistry);
    }

    public ExchangePhase getPhase() {
        return this._phase;
    }

    private void initInTransformSequence() {
        QName exchangeInputType = this._contract.getInvokerInvocationMetaData().getInputType();
        QName serviceOperationInputType = this._contract.getServiceOperation().getInputType();
        if (exchangeInputType != null && serviceOperationInputType != null) {
            TransformSequence.from((QName)exchangeInputType).to(serviceOperationInputType).associateWith((Exchange)this, Scope.IN);
        }
    }

    private void initOutTransformSequence() {
        QName serviceOperationOutputType = this._contract.getServiceOperation().getOutputType();
        QName exchangeOutputType = this._contract.getInvokerInvocationMetaData().getOutputType();
        if (serviceOperationOutputType != null && exchangeOutputType != null) {
            TransformSequence.from((QName)serviceOperationOutputType).to(exchangeOutputType).associateWith((Exchange)this, Scope.OUT);
        }
    }

    public static final class ExchangeImplFactory
    implements Serialization.Factory<ExchangeImpl> {
        public ExchangeImpl create(Class<ExchangeImpl> type) throws IOException {
            return new ExchangeImpl();
        }
    }
}

