/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import javax.xml.namespace.QName;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.ScannerOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ModelPullerScanner<M extends Model>
implements Scanner<M> {
    private Type _type;
    private String _classpath;
    private URI _uri;
    private URL _url;
    private Resource _resource;
    private File _file;
    private InputStream _inputStream;
    private Reader _reader;
    private InputSource _inputSource;
    private Document _document;
    private Element _element;
    private QName _qname;

    public ModelPullerScanner() {
        this("/META-INF/switchyard.xml");
    }

    public ModelPullerScanner(String classpath) {
        this._type = Type.CLASSPATH;
        this._classpath = classpath;
    }

    public ModelPullerScanner(URI uri) {
        this._type = Type.URI;
        this._uri = uri;
    }

    public ModelPullerScanner(URL url) {
        this._type = Type.URL;
        this._url = url;
    }

    public ModelPullerScanner(Resource resource) {
        this._type = Type.RESOURCE;
        this._resource = resource;
    }

    public ModelPullerScanner(File file) {
        this._type = Type.FILE;
        this._file = file;
    }

    public ModelPullerScanner(InputStream inputStream) {
        this._type = Type.INPUT_STREAM;
        this._inputStream = inputStream;
    }

    public ModelPullerScanner(Reader reader) {
        this._type = Type.READER;
        this._reader = reader;
    }

    public ModelPullerScanner(InputSource inputSource) {
        this._type = Type.INPUT_SOURCE;
        this._inputSource = inputSource;
    }

    public ModelPullerScanner(Document document) {
        this._type = Type.DOCUMENT;
        this._document = document;
    }

    public ModelPullerScanner(Element element) {
        this._type = Type.ELEMENT;
        this._element = element;
    }

    public ModelPullerScanner(QName qname) {
        this._type = Type.QNAME;
        this._qname = qname;
    }

    @Override
    public ScannerOutput<M> scan(ScannerInput<M> input) throws IOException {
        Object model;
        switch (this._type) {
            case CLASSPATH: {
                model = (Model)new ModelPuller().pull(this._classpath, this.getClass());
                break;
            }
            case URI: {
                model = (Model)new ModelPuller().pull(this._uri);
                break;
            }
            case URL: {
                model = (Model)new ModelPuller().pull(this._url);
                break;
            }
            case RESOURCE: {
                model = (Model)new ModelPuller().pull(this._resource);
                break;
            }
            case FILE: {
                model = (Model)new ModelPuller().pull(this._file);
                break;
            }
            case INPUT_STREAM: {
                model = new ModelPuller().pull(this._inputStream);
                break;
            }
            case READER: {
                model = new ModelPuller().pull(this._reader);
                break;
            }
            case INPUT_SOURCE: {
                model = new ModelPuller().pull(this._inputSource);
                break;
            }
            case DOCUMENT: {
                model = new ModelPuller().pull(this._document);
                break;
            }
            case ELEMENT: {
                model = new ModelPuller().pull(this._element);
                break;
            }
            case QNAME: {
                model = new ModelPuller().pull(this._qname);
                break;
            }
            default: {
                model = null;
            }
        }
        return new ScannerOutput<Object>().setModel(model);
    }

    private static enum Type {
        CLASSPATH,
        URI,
        URL,
        RESOURCE,
        FILE,
        INPUT_STREAM,
        READER,
        INPUT_SOURCE,
        DOCUMENT,
        ELEMENT,
        QNAME;

    }
}

