/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import org.jboss.dmr.ModelNode;
import org.switchyard.admin.Application;
import org.switchyard.admin.Component;
import org.switchyard.admin.Service;

public final class ModelNodeCreationUtil {
    public static ModelNode createApplicationNode(Application application) {
        ModelNode applicationNode = new ModelNode();
        ModelNode servicesNode = new ModelNode();
        for (Service service : application.getServices()) {
            servicesNode.add(ModelNodeCreationUtil.createServiceNode(service));
        }
        applicationNode.get("name").set(application.getName().toString());
        applicationNode.get("services").set(servicesNode);
        return applicationNode;
    }

    public static ModelNode createSimpleApplicationNode(Application application) {
        ModelNode applicationNode = new ModelNode();
        ModelNode servicesNode = new ModelNode();
        for (Service service : application.getServices()) {
            servicesNode.add(service.getName().toString());
        }
        applicationNode.get("name").set(application.getName().toString());
        applicationNode.get("services").set(servicesNode);
        return applicationNode;
    }

    public static ModelNode createServiceNode(Service service) {
        ModelNode serviceNode = ModelNodeCreationUtil.createSimpleServiceNode(service);
        String interfaceName = service.getInterface();
        if (interfaceName == null) {
            serviceNode.get("interface");
        } else {
            serviceNode.get("interface").set(interfaceName);
        }
        Component implementation = service.getImplementation();
        if (implementation == null) {
            serviceNode.get("implementation");
        } else {
            serviceNode.get("implementation").set(implementation.getName());
        }
        ModelNode gatewaysNode = new ModelNode();
        for (Component gateway : service.getGateways()) {
            gatewaysNode.add(gateway.getName());
        }
        serviceNode.get("gateways").set(gatewaysNode);
        return serviceNode;
    }

    public static ModelNode createSimpleServiceNode(Service service) {
        ModelNode serviceNode = new ModelNode();
        serviceNode.get("name").set(service.getName().toString());
        serviceNode.get("application").set(service.getApplication().getName().toString());
        return serviceNode;
    }

    public static ModelNode createComponentNode(Component component) {
        ModelNode componentNode = new ModelNode();
        componentNode.get("name").set(component.getName());
        componentNode.get("type").set(component.getType().toString());
        componentNode.get("configSchema").set(component.getConfigSchema());
        return componentNode;
    }

    private ModelNodeCreationUtil() {
    }
}

