/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.admin.ModelNodeCreationUtil;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemReadApplication
implements OperationStepHandler {
    public static final SwitchYardSubsystemReadApplication INSTANCE = new SwitchYardSubsystemReadApplication();

    private SwitchYardSubsystemReadApplication() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                ModelNode applications = context.getResult();
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                if (operation.hasDefined("name")) {
                    QName applicationName = QName.valueOf(operation.get("name").asString());
                    Application application = switchYard.findApplication(applicationName);
                    if (application != null) {
                        applications.add(ModelNodeCreationUtil.createSimpleApplicationNode(application));
                    }
                } else {
                    for (Application application : switchYard.getApplications()) {
                        applications.add(ModelNodeCreationUtil.createSimpleApplicationNode(application));
                    }
                }
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }
}

