/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.admin.ModelNodeCreationUtil;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemReadService
implements OperationStepHandler {
    public static final SwitchYardSubsystemReadService INSTANCE = new SwitchYardSubsystemReadService();

    private SwitchYardSubsystemReadService() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                List<Object> services = Collections.emptyList();
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                if (operation.hasDefined("application-name")) {
                    QName applicationName = QName.valueOf(operation.get("application-name").asString());
                    Application application = switchYard.findApplication(applicationName);
                    if (application != null) {
                        if (operation.hasDefined("service-name")) {
                            Service service = SwitchYardSubsystemReadService.this.findService(QName.valueOf(operation.get("service-name").asString()), application);
                            if (service != null) {
                                services = Collections.singletonList(service);
                            }
                        } else {
                            services = application.getServices();
                        }
                    }
                } else if (operation.hasDefined("service-name")) {
                    QName serviceName = QName.valueOf(operation.get("service-name").asString());
                    services = new ArrayList();
                    for (Application application : switchYard.getApplications()) {
                        Service service = SwitchYardSubsystemReadService.this.findService(serviceName, application);
                        if (service == null) continue;
                        services.add(service);
                    }
                } else {
                    services = switchYard.getServices();
                }
                SwitchYardSubsystemReadService.this.addServiceNodes(context.getResult(), services);
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }

    private void addServiceNodes(ModelNode result, List<Service> services) {
        for (Service service : services) {
            result.add(ModelNodeCreationUtil.createServiceNode(service));
        }
    }

    private Service findService(QName serviceName, Application application) {
        for (Service service : application.getServices()) {
            if (!serviceName.equals(service.getName())) continue;
            return service;
        }
        return null;
    }
}

