/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.switchyard.as7.extension.SwitchYardDeploymentMarker;

public class SwitchYardCdiIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final String SWITCHYARD_CDI_EXTENSION = "org.switchyard.component.bean.SwitchYardCDIServiceDiscovery";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!SwitchYardDeploymentMarker.isSwitchYardDeployment(deploymentUnit)) {
            return;
        }
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            DeploymentUnit parent;
            DeploymentUnit deploymentUnit2 = parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
            synchronized (deploymentUnit2) {
                boolean found = false;
                List extensions = parent.getAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS);
                for (Metadata extension : extensions) {
                    if (!extension.getLocation().equals(SWITCHYARD_CDI_EXTENSION)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    try {
                        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                        Class clazz = module.getClassLoader().loadClass(SWITCHYARD_CDI_EXTENSION);
                        final Extension ext = (Extension)clazz.newInstance();
                        Metadata<Extension> metadata = new Metadata<Extension>(){

                            public Extension getValue() {
                                return ext;
                            }

                            public String getLocation() {
                                return SwitchYardCdiIntegrationProcessor.SWITCHYARD_CDI_EXTENSION;
                            }
                        };
                        parent.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
                    }
                    catch (InstantiationException ie) {
                        throw new DeploymentUnitProcessingException((Throwable)ie);
                    }
                    catch (IllegalAccessException iae) {
                        throw new DeploymentUnitProcessingException((Throwable)iae);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new DeploymentUnitProcessingException((Throwable)cnfe);
                    }
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

