/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.switchyard.as7.extension.SwitchYardDeploymentMarker;
import org.switchyard.as7.extension.deployment.SwitchYardMetaData;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.switchyard.SwitchYardModel;

public class SwitchYardConfigProcessor
implements DeploymentUnitProcessor {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!SwitchYardDeploymentMarker.isSwitchYardDeployment(deploymentUnit)) {
            return;
        }
        SwitchYardMetaData switchYardMetaData = (SwitchYardMetaData)deploymentUnit.getAttachment(SwitchYardMetaData.ATTACHMENT_KEY);
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        try {
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            is = switchYardMetaData.getSwitchYardFile().openStream();
            SwitchYardModel switchyardModel = (SwitchYardModel)new ModelPuller().pull(is);
            switchYardMetaData.setSwitchYardModel(switchyardModel);
        }
        catch (IOException ioe) {
            throw new DeploymentUnitProcessingException((Throwable)ioe);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    LOG.error((Object)ioe);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

