/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import javax.xml.namespace.QName;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.base.BaseSwitchYard;
import org.switchyard.as7.extension.admin.ModelNodeCreationUtil;
import org.switchyard.as7.extension.deployment.SwitchYardDeploymentState;
import org.switchyard.as7.extension.services.SwitchYardAdminService;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.Deployment;
import org.switchyard.deploy.internal.DeploymentListener;

public class SwitchYardDeployment {
    public static final AttachmentKey<SwitchYardDeployment> ATTACHMENT_KEY = AttachmentKey.create(SwitchYardDeployment.class);
    private final DeploymentUnit _deployUnit;
    private SwitchYardDeploymentState _deploymentState;
    private Deployment _deployment;

    public SwitchYardDeployment(DeploymentUnit deploymentUnit, SwitchYardModel config) {
        this._deployUnit = deploymentUnit;
        this._deployment = new Deployment(config);
    }

    public void create() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Module module = (Module)this._deployUnit.getAttachment(Attachments.MODULE);
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            this.setDeploymentState(SwitchYardDeploymentState.INITIALIZING);
            this._deployment.init(ServiceDomainManager.createDomain());
            this.setDeploymentState(SwitchYardDeploymentState.STARTING);
            this._deployment.start();
            this.setDeploymentState(SwitchYardDeploymentState.STARTED);
            this.registerManagementNodes();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Module module = (Module)this._deployUnit.getAttachment(Attachments.MODULE);
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            if (this._deploymentState == SwitchYardDeploymentState.STARTED) {
                this._deployment.stop();
                this.setDeploymentState(SwitchYardDeploymentState.STOPPED);
                this.unregisterManagementNodes();
            }
            if (this._deploymentState == SwitchYardDeploymentState.STARTING || this._deploymentState == SwitchYardDeploymentState.STOPPED) {
                this._deployment.destroy();
                this.setDeploymentState(SwitchYardDeploymentState.DESTROYED);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    public void setDeploymentState(SwitchYardDeploymentState deploymentState) {
        this._deploymentState = deploymentState;
    }

    public SwitchYardDeploymentState getDeploymentState() {
        return this._deploymentState;
    }

    public void setDeploymentListener(DeploymentListener listener) {
        this._deployment.addDeploymentListener(listener);
    }

    public void removeDeploymentListener(DeploymentListener listener) {
        this._deployment.removeDeploymentListener(listener);
    }

    private void registerManagementNodes() {
        QName applicationName = this._deployment.getName();
        if (applicationName == null) {
            return;
        }
        ServiceController adminService = this._deployUnit.getServiceRegistry().getService(SwitchYardAdminService.SERVICE_NAME);
        if (adminService == null) {
            return;
        }
        BaseSwitchYard switchYard = (BaseSwitchYard)BaseSwitchYard.class.cast(adminService.getValue());
        if (switchYard == null) {
            return;
        }
        ModelNode deployNode = this._deployUnit.createDeploymentSubModel("switchyard", PathElement.pathElement((String)"application", (String)applicationName.toString()));
        Application application = switchYard.findApplication(applicationName);
        if (application == null) {
            return;
        }
        deployNode.set(ModelNodeCreationUtil.createApplicationNode(application));
    }

    private void unregisterManagementNodes() {
        QName applicationName = this._deployment.getName();
        if (applicationName == null) {
            return;
        }
        this._deployUnit.createDeploymentSubModel("switchyard", PathElement.pathElement((String)"application", (String)applicationName.toString())).clear();
    }
}

