/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.AbstractTxInvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.BidirectionalMap;

public class LocalTxInvocationContext
extends AbstractTxInvocationContext {
    private LocalTransaction localTransaction;

    @Override
    public boolean isTransactionValid() {
        Transaction t = this.getTransaction();
        int status = -1;
        if (t != null) {
            try {
                status = t.getStatus();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
        return status == 0 || status == 7;
    }

    @Override
    public boolean isOriginLocal() {
        return true;
    }

    @Override
    public Object getLockOwner() {
        return this.localTransaction.getGlobalTransaction();
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.localTransaction.getGlobalTransaction();
    }

    @Override
    public List<WriteCommand> getModifications() {
        return this.localTransaction == null ? null : this.localTransaction.getModifications();
    }

    public void setLocalTransaction(LocalTransaction localTransaction) {
        this.localTransaction = localTransaction;
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        return this.localTransaction != null ? this.localTransaction.lookupEntry(key) : null;
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.localTransaction.getLookedUpEntries();
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.localTransaction.putLookedUpEntry(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> lookedUpEntries) {
        for (Map.Entry<Object, CacheEntry> ce : lookedUpEntries.entrySet()) {
            this.localTransaction.putLookedUpEntry(ce.getKey(), ce.getValue());
        }
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        this.localTransaction.removeLookedUpEntry(key);
    }

    @Override
    public void clearLookedUpEntries() {
        this.localTransaction.clearLookedUpEntries();
    }

    @Override
    public boolean hasLockedKey(Object key) {
        return this.localTransaction != null && super.hasLockedKey(key);
    }

    public void remoteLocksAcquired(Collection<Address> nodes) {
        this.localTransaction.locksAcquired(nodes);
    }

    public Collection<Address> getRemoteLocksAcquired() {
        return this.localTransaction.getRemoteLocksAcquired();
    }

    @Override
    public AbstractCacheTransaction getCacheTrasaction() {
        return this.localTransaction;
    }
}

