/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.infinispan.CacheException;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.manager.ReflectionCache;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifierImpl;
import org.infinispan.util.ModuleProperties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class GlobalComponentRegistry
extends AbstractComponentRegistry {
    private static final Log log = LogFactory.getLog(GlobalComponentRegistry.class);
    private Thread shutdownHook;
    private boolean invokedFromShutdownHook;
    private final GlobalConfiguration globalConfiguration;
    private final Set<String> createdCaches;
    Map<String, ComponentRegistry> namedComponents = new HashMap<String, ComponentRegistry>();

    public GlobalComponentRegistry(GlobalConfiguration configuration, EmbeddedCacheManager cacheManager, ReflectionCache reflectionCache, Set<String> createdCaches) {
        super(reflectionCache);
        if (configuration == null) {
            throw new NullPointerException("GlobalConfiguration cannot be null!");
        }
        try {
            this.globalConfiguration = configuration;
            this.registerDefaultClassLoader(null);
            this.registerComponent((Object)this, GlobalComponentRegistry.class);
            this.registerComponent((Object)cacheManager, EmbeddedCacheManager.class);
            this.registerComponent((Object)configuration, GlobalConfiguration.class);
            this.registerComponent((Object)new CacheManagerJmxRegistration(), CacheManagerJmxRegistration.class);
            this.registerComponent((Object)new CacheManagerNotifierImpl(), CacheManagerNotifier.class);
            Map<Byte, ModuleCommandFactory> factories = ModuleProperties.moduleCommandFactories(configuration.getClassLoader());
            if (factories != null && !factories.isEmpty()) {
                this.registerNonVolatileComponent(factories, "org.infinispan.modules.command.factories");
            } else {
                this.registerNonVolatileComponent(Collections.emptyMap(), "org.infinispan.modules.command.factories");
            }
            this.createdCaches = createdCaches;
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a GlobalComponentRegistry!", e);
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected void removeShutdownHook() {
        if (!this.invokedFromShutdownHook && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    @Override
    protected void addShutdownHook() {
        boolean registerShutdownHook;
        ArrayList<MBeanServer> al = MBeanServerFactory.findMBeanServer(null);
        boolean bl = registerShutdownHook = this.globalConfiguration.getShutdownHookBehavior() == GlobalConfiguration.ShutdownHookBehavior.DEFAULT && al.isEmpty() || this.globalConfiguration.getShutdownHookBehavior() == GlobalConfiguration.ShutdownHookBehavior.REGISTER;
        if (registerShutdownHook) {
            log.tracef("Registering a shutdown hook.  Configured behavior = %s", (Object)this.globalConfiguration.getShutdownHookBehavior());
            this.shutdownHook = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        GlobalComponentRegistry.this.invokedFromShutdownHook = true;
                        GlobalComponentRegistry.this.stop();
                    }
                    finally {
                        GlobalComponentRegistry.this.invokedFromShutdownHook = false;
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            log.tracef("Not registering a shutdown hook.  Configured behavior = %s", (Object)this.globalConfiguration.getShutdownHookBehavior());
        }
    }

    public final ComponentRegistry getNamedComponentRegistry(String name) {
        return this.namedComponents.get(name);
    }

    public final void registerNamedComponentRegistry(ComponentRegistry componentRegistry, String name) {
        this.namedComponents.put(name, componentRegistry);
    }

    public final void unregisterNamedComponentRegistry(String name) {
        this.namedComponents.remove(name);
    }

    public final void rewireNamedRegistries() {
        for (ComponentRegistry cr : this.namedComponents.values()) {
            cr.rewire();
        }
    }

    @Override
    public void start() {
        try {
            boolean needToNotify;
            boolean bl = needToNotify = this.state != ComponentStatus.RUNNING && this.state != ComponentStatus.INITIALIZING;
            if (needToNotify) {
                for (ModuleLifecycle l : moduleLifecycles) {
                    l.cacheManagerStarting(this, this.globalConfiguration);
                }
            }
            super.start();
            if (needToNotify && this.state == ComponentStatus.RUNNING) {
                for (ModuleLifecycle l : moduleLifecycles) {
                    l.cacheManagerStarted(this);
                }
            }
        }
        catch (RuntimeException rte) {
            block9: {
                try {
                    this.resetVolatileComponents();
                    this.rewire();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Unable to reset GlobalComponentRegistry after a failed restart!", e);
                        break block9;
                    }
                    log.warn("Unable to reset GlobalComponentRegistry after a failed restart due to an exception of type " + e.getClass().getSimpleName() + " with message " + e.getMessage() + ". Use DEBUG level logging for full exception details.");
                }
            }
            throw new EmbeddedCacheManagerStartupException(rte);
        }
    }

    @Override
    public void stop() {
        boolean needToNotify;
        boolean bl = needToNotify = this.state == ComponentStatus.RUNNING || this.state == ComponentStatus.INITIALIZING;
        if (needToNotify) {
            for (ModuleLifecycle l : moduleLifecycles) {
                l.cacheManagerStopping(this);
            }
        }
        super.stop();
        if (this.state == ComponentStatus.TERMINATED && needToNotify) {
            for (ModuleLifecycle l : moduleLifecycles) {
                l.cacheManagerStopped(this);
            }
        }
    }

    public final GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public boolean removeCache(String cacheName) {
        return this.createdCaches.remove(cacheName);
    }
}

