/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryInfoKey;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;

@DefaultFactoryFor(classes={RecoveryManager.class})
public class RecoveryManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final long DEFAULT_EXPIRY = TimeUnit.HOURS.toMillis(6L);

    public <RecoveryManager> RecoveryManager construct(Class<RecoveryManager> componentType) {
        String cacheName;
        this.checkAsyncCache(this.configuration);
        boolean recoveryEnabled = this.configuration.isTransactionRecoveryEnabled();
        String string = cacheName = this.configuration.getName() == null ? "___defaultcache" : this.configuration.getName();
        if (recoveryEnabled) {
            String recoveryCacheName = this.configuration.getTransactionRecoveryCacheName();
            if (this.log.isTraceEnabled()) {
                this.log.tracef("Using recovery cache name %s", recoveryCacheName);
            }
            EmbeddedCacheManager cm = this.componentRegistry.getGlobalComponentRegistry().getComponent(EmbeddedCacheManager.class);
            boolean useDefaultCache = recoveryCacheName.equals("__recoveryInfoCacheName__");
            if (!useDefaultCache) {
                if (!cm.getCacheNames().contains(recoveryCacheName)) {
                    throw new ConfigurationException("Recovery cache (" + recoveryCacheName + ") does not exist!!");
                }
            } else if (!cm.getCacheNames().contains(recoveryCacheName)) {
                Configuration config = this.getDefaultRecoveryCacheConfig();
                cm.defineConfiguration(recoveryCacheName, config);
            }
            return (RecoveryManager)this.buildRecoveryManager(cacheName, recoveryCacheName, cm, useDefaultCache);
        }
        return null;
    }

    private void checkAsyncCache(Configuration configuration) {
        if (configuration.isTransactionRecoveryEnabled() && configuration.isOnePhaseCommit()) {
            throw new ConfigurationException("Recovery for async caches is not supported!");
        }
    }

    private Configuration getDefaultRecoveryCacheConfig() {
        Configuration config = new Configuration();
        config.fluent().transaction().transactionManagerLookup(new TransactionManagerLookup(){

            @Override
            public TransactionManager getTransactionManager() throws Exception {
                return null;
            }
        });
        config.fluent().clustering().mode(Configuration.CacheMode.LOCAL);
        config.fluent().expiration().lifespan(DEFAULT_EXPIRY);
        config.fluent().recovery().disable();
        return config;
    }

    private RecoveryManager buildRecoveryManager(String cacheName, String recoveryCacheName, EmbeddedCacheManager cm, boolean isDefault) {
        if (this.log.isTraceEnabled()) {
            this.log.tracef("About to obtain a reference to the recovery cache: %s", recoveryCacheName);
        }
        Cache<RecoveryInfoKey, RecoveryAwareRemoteTransaction> recoveryCache = cm.getCache(recoveryCacheName);
        String txLookup = recoveryCache.getConfiguration().getTransactionManagerLookupClass();
        if (!isDefault && txLookup.equals(this.configuration.getTransactionManagerLookupClass())) {
            throw new ConfigurationException("Same transaction manager lookup(" + txLookup + " used by both recovery cache (" + recoveryCacheName + ") and main cache(" + cacheName + "). This is not allowed!");
        }
        if (this.log.isTraceEnabled()) {
            this.log.tracef("Obtained a reference to the recovery cache: %s", recoveryCacheName);
        }
        return new RecoveryManagerImpl(recoveryCache, cacheName);
    }
}

