/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BinarySecurity {
    public static final QName TOKEN_BST = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
    public static final QName TOKEN_KI = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
    public static final String BASE64_ENCODING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private static final Log LOG = LogFactory.getLog(BinarySecurity.class);
    protected Element element = null;

    public BinarySecurity(Element elem) throws WSSecurityException {
        this(elem, true);
    }

    public BinarySecurity(Element elem, boolean bspCompliant) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN_BST) && !el.equals(TOKEN_KI)) {
            throw new WSSecurityException(4, "unhandledToken", new Object[]{el});
        }
        String encoding = this.getEncodingType();
        if (bspCompliant && !BASE64_ENCODING.equals(encoding)) {
            throw new WSSecurityException(4, "badEncoding", new Object[]{encoding});
        }
        String valueType = this.getValueType();
        if (bspCompliant && (valueType == null || "".equals(valueType))) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{valueType});
        }
    }

    public BinarySecurity(Document doc) {
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        this.setEncodingType(BASE64_ENCODING);
        this.element.appendChild(doc.createTextNode(""));
    }

    public void addWSSENamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
    }

    public void addWSUNamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    public String getValueType() {
        return this.element.getAttribute("ValueType");
    }

    public void setValueType(String type) {
        this.element.setAttributeNS(null, "ValueType", type);
    }

    public String getEncodingType() {
        return this.element.getAttribute("EncodingType");
    }

    public void setEncodingType(String encoding) {
        this.element.setAttributeNS(null, "EncodingType", encoding);
    }

    public byte[] getToken() {
        StringBuilder builder = new StringBuilder();
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (3 != node.getNodeType()) continue;
            builder.append(((Text)node).getData());
        }
        try {
            return Base64.decode(builder.toString());
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    public void setToken(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        Text node = this.getFirstNode();
        node.setData(Base64.encode(data));
    }

    protected Text getFirstNode() {
        Node node = this.element.getFirstChild();
        return node != null && 3 == node.getNodeType() ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public int hashCode() {
        int result = 17;
        byte[] token = this.getToken();
        if (token != null) {
            result = 31 * result + Arrays.hashCode(token);
        }
        result = 31 * result + this.getValueType().hashCode();
        result = 31 * result + this.getEncodingType().hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BinarySecurity)) {
            return false;
        }
        BinarySecurity binarySecurity = (BinarySecurity)object;
        byte[] token = binarySecurity.getToken();
        if (!Arrays.equals(token, this.getToken())) {
            return false;
        }
        String valueType = binarySecurity.getValueType();
        if (!valueType.equals(this.getValueType())) {
            return false;
        }
        String encodingType = binarySecurity.getEncodingType();
        return encodingType.equals(this.getEncodingType());
    }
}

