/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.MethodSignatureImpl;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decorators {
    public static Map<MethodSignature, WeldMethod<?, ?>> getDecoratorMethods(BeanManagerImpl beanManager, Set<Type> decoratedTypes, WeldClass<?> decoratorClass) {
        List<WeldMethod<?, ?>> decoratedMethods = Decorators.getDecoratedMethods(beanManager, decoratedTypes);
        HashMap decoratorMethods = new HashMap();
        for (WeldMethod<?, ?> method : decoratorClass.getWeldMethods()) {
            MethodSignatureImpl methodSignature = new MethodSignatureImpl(method);
            for (WeldMethod<?, ?> decoratedMethod : decoratedMethods) {
                if (!new MethodSignatureImpl(decoratedMethod).equals(methodSignature)) continue;
                decoratorMethods.put(methodSignature, method);
            }
        }
        return decoratorMethods;
    }

    public static List<WeldMethod<?, ?>> getDecoratedMethods(BeanManagerImpl beanManager, Set<Type> decoratedTypes) {
        ArrayList methods = new ArrayList();
        for (Type type : decoratedTypes) {
            WeldClass<?> weldClass = Decorators.getWeldClassOfDecoratedType(beanManager, type);
            for (WeldMethod<?, ?> method : weldClass.getWeldMethods()) {
                if (methods.contains(method)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static WeldClass<?> getWeldClassOfDecoratedType(BeanManagerImpl beanManager, Type type) {
        if (type instanceof Class) {
            return (WeldClass)beanManager.createAnnotatedType((Class)type);
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (WeldClass)beanManager.createAnnotatedType((Class)((ParameterizedType)type).getRawType());
        }
        throw new IllegalStateException(BeanMessage.UNABLE_TO_PROCESS, type);
    }

    public static <T> WeldMethod<?, ?> findDecoratorMethod(WeldDecorator<T> decorator, Map<MethodSignature, WeldMethod<?, ?>> decoratorMethods, Method method) {
        MethodSignatureImpl key = new MethodSignatureImpl(method);
        if (decoratorMethods.containsKey(key)) {
            return decoratorMethods.get(key);
        }
        for (WeldMethod<?, ?> decoratorMethod : decoratorMethods.values()) {
            if (method.getParameterTypes().length != decoratorMethod.getParameters().size() || !method.getName().equals(decoratorMethod.getName())) continue;
            boolean parameterMatch = true;
            for (int i = 0; parameterMatch && i < method.getParameterTypes().length; ++i) {
                parameterMatch = parameterMatch && decoratorMethod.getParameterTypesAsArray()[i].isAssignableFrom(method.getParameterTypes()[i]);
            }
            if (!parameterMatch) continue;
            return decoratorMethod;
        }
        return null;
    }
}

