/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import org.apache.xerces.impl.xs.opti.DefaultElement;
import org.apache.xerces.impl.xs.opti.NamedNodeMapImpl;
import org.apache.xerces.impl.xs.opti.SchemaDOM;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementImpl
extends DefaultElement {
    SchemaDOM schemaDOM;
    Attr[] attrs;
    int row = -1;
    int col = -1;
    int parentRow = -1;
    int line;
    int column;
    int charOffset;
    String fAnnotation;
    String fSyntheticAnnotation;

    public ElementImpl(int line, int column, int offset) {
        this.nodeType = 1;
        this.line = line;
        this.column = column;
        this.charOffset = offset;
    }

    public ElementImpl(int line, int column) {
        this(line, column, -1);
    }

    public ElementImpl(String prefix, String localpart, String rawname, String uri, int line, int column, int offset) {
        super(prefix, localpart, rawname, uri, (short)1);
        this.line = line;
        this.column = column;
        this.charOffset = offset;
    }

    public ElementImpl(String prefix, String localpart, String rawname, String uri, int line, int column) {
        this(prefix, localpart, rawname, uri, line, column, -1);
    }

    @Override
    public Document getOwnerDocument() {
        return this.schemaDOM;
    }

    @Override
    public Node getParentNode() {
        return this.schemaDOM.relations[this.row][0];
    }

    @Override
    public boolean hasChildNodes() {
        return this.parentRow != -1;
    }

    @Override
    public Node getFirstChild() {
        if (this.parentRow == -1) {
            return null;
        }
        return this.schemaDOM.relations[this.parentRow][1];
    }

    @Override
    public Node getLastChild() {
        int i;
        if (this.parentRow == -1) {
            return null;
        }
        for (i = 1; i < this.schemaDOM.relations[this.parentRow].length; ++i) {
            if (this.schemaDOM.relations[this.parentRow][i] != null) continue;
            return this.schemaDOM.relations[this.parentRow][i - 1];
        }
        if (i == 1) {
            ++i;
        }
        return this.schemaDOM.relations[this.parentRow][i - 1];
    }

    @Override
    public Node getPreviousSibling() {
        if (this.col == 1) {
            return null;
        }
        return this.schemaDOM.relations[this.row][this.col - 1];
    }

    @Override
    public Node getNextSibling() {
        if (this.col == this.schemaDOM.relations[this.row].length - 1) {
            return null;
        }
        return this.schemaDOM.relations[this.row][this.col + 1];
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new NamedNodeMapImpl(this.attrs);
    }

    @Override
    public boolean hasAttributes() {
        return this.attrs.length != 0;
    }

    @Override
    public String getTagName() {
        return this.rawname;
    }

    @Override
    public String getAttribute(String name) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(name)) continue;
            return this.attrs[i].getValue();
        }
        return "";
    }

    @Override
    public Attr getAttributeNode(String name) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(name)) continue;
            return this.attrs[i];
        }
        return null;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getLocalName().equals(localName) || !this.attrs[i].getNamespaceURI().equals(namespaceURI)) continue;
            return this.attrs[i].getValue();
        }
        return "";
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(localName) || !this.attrs[i].getNamespaceURI().equals(namespaceURI)) continue;
            return this.attrs[i];
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String name) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(localName) || !this.attrs[i].getNamespaceURI().equals(namespaceURI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setAttribute(String name, String value) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(name)) continue;
            this.attrs[i].setValue(value);
            return;
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public int getCharacterOffset() {
        return this.charOffset;
    }

    public String getAnnotation() {
        return this.fAnnotation;
    }

    public String getSyntheticAnnotation() {
        return this.fSyntheticAnnotation;
    }
}

