/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.File;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessage
extends DefaultMessage {
    private static final transient Logger LOG = LoggerFactory.getLogger(JmsMessage.class);
    private javax.jms.Message jmsMessage;
    private JmsBinding binding;

    public JmsMessage(javax.jms.Message jmsMessage, JmsBinding binding) {
        this.setJmsMessage(jmsMessage);
        this.setBinding(binding);
    }

    public String toString() {
        if (this.jmsMessage != null) {
            return "JmsMessage: " + this.jmsMessage;
        }
        return "JmsMessage: " + this.getBody();
    }

    public void copyFrom(Message that) {
        this.getHeaders().clear();
        boolean copyMessageId = true;
        if (that instanceof JmsMessage) {
            JmsMessage thatMessage = (JmsMessage)that;
            this.jmsMessage = thatMessage.jmsMessage;
            if (this.jmsMessage != null) {
                copyMessageId = false;
            }
        }
        if (copyMessageId) {
            this.setMessageId(that.getMessageId());
        }
        this.setBody(that.getBody());
        this.setFault(that.isFault());
        if (that.hasHeaders()) {
            this.getHeaders().putAll(that.getHeaders());
        }
        this.getAttachments().clear();
        if (that.hasAttachments()) {
            this.getAttachments().putAll(that.getAttachments());
        }
    }

    public javax.jms.Message getJmsMessage() {
        return this.jmsMessage;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = (JmsBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), JmsBinding.class);
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public void setJmsMessage(javax.jms.Message jmsMessage) {
        if (jmsMessage != null) {
            try {
                this.setMessageId(jmsMessage.getJMSMessageID());
            }
            catch (JMSException e) {
                LOG.warn("Unable to retrieve JMSMessageID from JMS Message", (Throwable)e);
            }
        }
        this.jmsMessage = jmsMessage;
    }

    public void setBody(Object body) {
        super.setBody(body);
        if (body == null) {
            this.ensureInitialHeaders();
            this.jmsMessage = null;
        }
    }

    public Object getHeader(String name) {
        Object answer = null;
        if (this.jmsMessage != null && !this.hasPopulatedHeaders() && !name.startsWith("JMS")) {
            try {
                answer = this.getBinding().getObjectProperty(this.jmsMessage, name);
            }
            catch (JMSException e) {
                throw new RuntimeExchangeException("Unable to retrieve header from JMS Message: " + name, this.getExchange(), (Throwable)e);
            }
        }
        if (answer == null && (this.hasPopulatedHeaders() || name.startsWith("JMS"))) {
            answer = super.getHeader(name);
        }
        return answer;
    }

    public Map<String, Object> getHeaders() {
        this.ensureInitialHeaders();
        return super.getHeaders();
    }

    public Object removeHeader(String name) {
        this.ensureInitialHeaders();
        return super.removeHeader(name);
    }

    public void setHeaders(Map<String, Object> headers) {
        this.ensureInitialHeaders();
        super.setHeaders(headers);
    }

    public void setHeader(String name, Object value) {
        this.ensureInitialHeaders();
        super.setHeader(name, value);
    }

    public JmsMessage newInstance() {
        return new JmsMessage(null, this.binding);
    }

    public boolean shouldCreateNewMessage() {
        return super.hasPopulatedHeaders();
    }

    protected void ensureInitialHeaders() {
        if (this.jmsMessage != null && !this.hasPopulatedHeaders()) {
            super.setHeaders(this.createHeaders());
        }
    }

    protected Object createBody() {
        if (this.jmsMessage != null) {
            return this.getBinding().extractBodyFromJms(this.getExchange(), this.jmsMessage);
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.jmsMessage != null && map != null) {
            map.putAll(this.getBinding().extractHeadersFromJms(this.jmsMessage, this.getExchange()));
        }
    }

    protected String createMessageId() {
        if (this.jmsMessage == null) {
            LOG.trace("No javax.jms.Message set so generating a new message id");
            return super.createMessageId();
        }
        try {
            String id = this.getDestinationAsString(this.jmsMessage.getJMSDestination()) + this.jmsMessage.getJMSMessageID();
            return this.getSanitizedString(id);
        }
        catch (JMSException e) {
            throw new RuntimeExchangeException("Unable to retrieve JMSMessageID from JMS Message", this.getExchange(), (Throwable)e);
        }
    }

    private String getDestinationAsString(Destination destination) throws JMSException {
        String result = destination == null ? "null destination!" + File.separator : (destination instanceof Topic ? "topic" + File.separator + ((Topic)destination).getTopicName() + File.separator : "queue" + File.separator + ((Queue)destination).getQueueName() + File.separator);
        return result;
    }

    private String getSanitizedString(Object value) {
        return value != null ? value.toString().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_") : "";
    }
}

