/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.util;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.vfs.VirtualFile;

public class LazyInputStream
extends InputStream {
    private VirtualFile file;
    private InputStream stream;

    public LazyInputStream(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    protected synchronized InputStream openStream() throws IOException {
        if (this.stream == null) {
            this.stream = this.file.openStream();
        }
        return this.stream;
    }

    @Override
    public int read() throws IOException {
        return this.openStream().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.openStream().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.openStream().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.openStream().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.openStream().available();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.stream == null) {
            return;
        }
        this.openStream().close();
        this.stream = null;
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.openStream().mark(readlimit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() throws IOException {
        this.openStream().reset();
    }

    @Override
    public boolean markSupported() {
        try {
            return this.openStream().markSupported();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

