/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltUriResolver
implements URIResolver {
    private static final transient Logger LOG = LoggerFactory.getLogger(XsltUriResolver.class);
    private final ClassResolver resolver;
    private final String location;

    public XsltUriResolver(ClassResolver resolver, String location) {
        this.resolver = resolver;
        this.location = location;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (ObjectHelper.isEmpty(href)) {
            throw new TransformerException("include href is empty");
        }
        LOG.trace("Resolving URI with href: {} and base: {}", (Object)href, (Object)base);
        if (href.startsWith("classpath:")) {
            LOG.debug("Resolving URI from classpath: {}", (Object)href);
            String name = ObjectHelper.after(href, ":");
            InputStream is = this.resolver.loadResourceAsStream(name);
            if (is == null) {
                throw new TransformerException("Cannot find " + name + " in classpath");
            }
            return new StreamSource(is);
        }
        if (href.startsWith("file:")) {
            LOG.debug("Resolving URI from file: {}", (Object)href);
            String name = ObjectHelper.after(href, ":");
            File file = new File(name);
            return new StreamSource(file);
        }
        String path = FileUtil.onlyPath(this.location);
        if (ObjectHelper.isEmpty(path)) {
            path = "classpath:" + href;
            return this.resolve(path, base);
        }
        path = "classpath:" + path + File.separator + href;
        return this.resolve(path, base);
    }
}

