/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangedExclusiveReadLockStrategy
extends MarkerFileExclusiveReadLockStrategy {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileChangedExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 1000L;

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        boolean exclusive;
        block6: {
            File target = new File(file.getAbsoluteFilePath());
            exclusive = false;
            LOG.trace("Waiting for exclusive read lock to file: {}", file);
            try {
                long lastModified = Long.MIN_VALUE;
                long length = Long.MIN_VALUE;
                StopWatch watch = new StopWatch();
                while (!exclusive) {
                    long delta;
                    if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                        LOG.warn("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + file);
                        return false;
                    }
                    long newLastModified = target.lastModified();
                    long newLength = target.length();
                    LOG.trace("Previous last modified: {}, new last modified: {}", (Object)lastModified, (Object)newLastModified);
                    LOG.trace("Previous length: {}, new length: {}", (Object)length, (Object)newLength);
                    if (newLastModified == lastModified && newLength == length) {
                        exclusive = super.acquireExclusiveReadLock(operations, file, exchange);
                        continue;
                    }
                    lastModified = newLastModified;
                    length = newLength;
                    boolean interrupted = this.sleep();
                    if (!interrupted) continue;
                    return false;
                }
            }
            catch (IOException e) {
                if (this.timeout == 0L) {
                    throw e;
                }
                LOG.debug("Cannot acquire read lock. Will try again.", (Throwable)e);
                boolean interrupted = this.sleep();
                if (!interrupted) break block6;
                return false;
            }
        }
        return exclusive;
    }

    private boolean sleep() {
        LOG.trace("Exclusive read lock not granted. Sleeping for {} millis.", (Object)this.checkInterval);
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }
}

